/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.gtf;

import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.filter.FilterPredicate;
import de.unknownreality.dataframe.gtf.GTFField;
import de.unknownreality.dataframe.gtf.GTFReader;
import de.unknownreality.dataframe.gtf.GTFRow;
import de.unknownreality.dataframe.gtf.GTFSettings;
import de.unknownreality.dataframe.io.ReaderBuilder;
import java.util.Map;

public class GTFReaderBuilder
implements ReaderBuilder<GTFRow, GTFReader> {
    private GTFSettings settings = new GTFSettings();

    public static GTFReaderBuilder create() {
        return new GTFReaderBuilder();
    }

    public GTFReaderBuilder withGTFField(GTFField field) {
        this.settings.addGTFField(field);
        return this;
    }

    public GTFReaderBuilder withAttribute(String name, DataFrameColumn column) {
        this.settings.addAttribute(name, column);
        return this;
    }

    public GTFReaderBuilder withAttribute(String name, Class<? extends DataFrameColumn> columnClass) {
        this.settings.addAttribute(name, columnClass);
        return this;
    }

    public GTFReaderBuilder withAttribute(String name) {
        this.settings.addAttribute(name);
        return this;
    }

    public GTFReaderBuilder withColumn(String name) {
        this.settings.addColumn(name);
        return this;
    }

    public GTFReaderBuilder withPreFilter(String predicate) {
        this.settings.setPreFilter(FilterPredicate.compile((String)predicate));
        return this;
    }

    public GTFReaderBuilder withPreFilter(FilterPredicate predicate) {
        this.settings.setPreFilter(predicate);
        return this;
    }

    public GTFReader build() {
        return new GTFReader(this.settings);
    }

    public ReaderBuilder<GTFRow, GTFReader> loadSettings(Map<String, String> map) throws Exception {
        for (String k : map.keySet()) {
            if (!k.startsWith("attr:")) continue;
            String colName = k.substring(5);
            this.withAttribute(colName);
        }
        return this;
    }

    public ReaderBuilder<GTFRow, GTFReader> selectColumn(String s) {
        return this.withColumn(s);
    }
}

