/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.gtf;

import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameException;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.common.KeyValueGetter;
import de.unknownreality.dataframe.csv.CSVIterator;
import de.unknownreality.dataframe.filter.FilterPredicate;
import de.unknownreality.dataframe.gtf.GTFField;
import de.unknownreality.dataframe.gtf.GTFHeader;
import de.unknownreality.dataframe.gtf.GTFRow;
import de.unknownreality.dataframe.gtf.GTFSettings;
import de.unknownreality.dataframe.gtf.GTFUtil;
import de.unknownreality.dataframe.io.BufferedStreamIterator;
import de.unknownreality.dataframe.io.ColumnInformation;
import de.unknownreality.dataframe.io.DataIterator;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTFIterator
extends BufferedStreamIterator<GTFRow>
implements DataIterator<GTFRow> {
    private static final Logger log = LoggerFactory.getLogger(CSVIterator.class);
    private static final String[] IGNORE_PREFIXES = new String[]{"#", "track", "seqname"};
    private int lineNumber = 0;
    private int rowNumber = 0;
    private GTFSettings settings;
    private GTFHeader header = new GTFHeader();
    private List<ColumnInformation> columnInformations = new ArrayList<ColumnInformation>();
    private int columnCount;
    private GTFRow bufferedRow = null;
    private Set<Integer> gtfFieldIndices = new HashSet<Integer>();
    private Map<String, Integer> attributeIndexMap = new HashMap<String, Integer>();
    private FilterPredicate filter = null;

    public GTFIterator(BufferedReader reader, GTFSettings settings) {
        super(reader);
        this.settings = settings;
        this.filter = settings.getPreFilter();
        List<GTFField> gtfFields = settings.isAddAllGTFFields() ? Arrays.asList(GTFField.values()) : settings.getGtfFields();
        this.columnCount = gtfFields.size() + settings.getAttributes().size();
        Collections.sort(gtfFields, Comparator.comparingInt(o -> o.index));
        int i = 0;
        for (GTFField gTFField : gtfFields) {
            this.gtfFieldIndices.add(gTFField.index);
            this.header.add(gTFField.name, gTFField.column.getClass(), gTFField.column.getType());
            this.columnInformations.add(new ColumnInformation(i++, gTFField.name, gTFField.column.getType()));
        }
        for (Map.Entry entry : settings.getAttributes().entrySet()) {
            this.header.add(entry.getKey(), ((DataFrameColumn)entry.getValue()).getClass(), ((DataFrameColumn)entry.getValue()).getType());
            this.attributeIndexMap.put((String)entry.getKey(), i);
            this.columnInformations.add(new ColumnInformation(i++, (String)entry.getKey(), ((DataFrameColumn)entry.getValue()).getType()));
        }
        this.loadNext();
    }

    public GTFRow next() {
        if (this.bufferedRow != null) {
            GTFRow nextRow = this.bufferedRow;
            this.bufferedRow = null;
            return nextRow;
        }
        return (GTFRow)super.next();
    }

    protected GTFRow getNext() {
        try {
            GTFRow row;
            Integer attrIdx;
            String line = this.getLine();
            while (line != null && "".equals(line.trim())) {
                line = this.getLine();
            }
            if (line == null) {
                GTFRow gTFRow = null;
                return gTFRow;
            }
            for (String prefix : IGNORE_PREFIXES) {
                if (prefix == null || "".equals(prefix) || !line.startsWith(prefix)) continue;
                GTFRow gTFRow = this.getNext();
                return gTFRow;
            }
            String[] values = line.split("\t");
            String[] rowValues = new String[this.columnCount];
            if (values.length < 9) {
                throw new DataFrameRuntimeException(String.format("invalid column count %s < 9", values.length));
            }
            int idx = 0;
            for (int i = 0; i < GTFField.values().length; ++i) {
                if (!this.settings.isAddAllGTFFields() && !this.gtfFieldIndices.contains(i)) continue;
                String val = values[i];
                rowValues[idx++] = ".".equals(val) || "".equals(val) ? Values.NA.toString() : values[i];
            }
            if (values[8].isEmpty() || values[8].equals(".")) {
                GTFRow i = new GTFRow(this.header, rowValues, this.rowNumber++);
                return i;
            }
            String[] attributeParts = GTFUtil.splitAttributes(values[8]);
            if (attributeParts.length % 2 != 0) {
                throw new DataFrameException(String.format("error parsing attributes '%s' in line %d", values[8], this.lineNumber));
            }
            HashSet<String> missingAttributes = new HashSet<String>(this.attributeIndexMap.keySet());
            for (int i = 0; i < attributeParts.length; i += 2) {
                String key = attributeParts[i];
                attrIdx = this.attributeIndexMap.get(key);
                if (attrIdx == null) continue;
                rowValues[attrIdx.intValue()] = attributeParts[i + 1];
                missingAttributes.remove(key);
            }
            for (String missingAttribute : missingAttributes) {
                attrIdx = this.attributeIndexMap.get(missingAttribute);
                rowValues[attrIdx.intValue()] = Values.NA.toString();
            }
            if (this.filter != null && !this.filter.valid((KeyValueGetter)(row = new GTFRow(this.header, rowValues, this.rowNumber++)))) {
                GTFRow gTFRow = this.getNext();
                return gTFRow;
            }
            GTFRow gTFRow = new GTFRow(this.header, rowValues, this.rowNumber++);
            return gTFRow;
        }
        catch (Exception e) {
            log.error("error reading file: {}:{}", (Object)this.lineNumber, (Object)e);
            this.close();
            throw new DataFrameRuntimeException(String.format("error reading gtf row: %d", this.lineNumber), (Throwable)e);
        }
        finally {
            ++this.lineNumber;
        }
    }

    public List<ColumnInformation> getColumnsInformation() {
        return this.columnInformations;
    }

    public Iterator<GTFRow> iterator() {
        return this;
    }
}

