/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.gtf;

import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.column.DoubleColumn;
import de.unknownreality.dataframe.column.IntegerColumn;
import de.unknownreality.dataframe.column.LongColumn;
import de.unknownreality.dataframe.column.StringColumn;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public enum GTFField {
    SEQNAME("seqname", 0, (DataFrameColumn)new StringColumn("seqname")),
    SOURCE("source", 1, (DataFrameColumn)new StringColumn("source")),
    FEATURE("feature", 2, (DataFrameColumn)new StringColumn("feature")),
    START("start", 3, (DataFrameColumn)new LongColumn("start")),
    END("end", 4, (DataFrameColumn)new LongColumn("end")),
    SCORE("score", 5, (DataFrameColumn)new DoubleColumn("score")),
    STRAND("strand", 6, (DataFrameColumn)new StringColumn("strand")),
    FRAME("frame", 7, (DataFrameColumn)new IntegerColumn("frame"));

    int index;
    String name;
    DataFrameColumn column;
    public static final Set<String> GTF_FIELD_NAMES;

    private GTFField(String name, int index, DataFrameColumn column) {
        this.index = index;
        this.name = name;
        this.column = column;
    }

    public static boolean isGTFField(String name) {
        return GTF_FIELD_NAMES.contains(name);
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends DataFrameColumn> getColType() {
        return this.column.getClass();
    }

    public Comparable parseValue(String value) {
        try {
            return (Comparable)this.column.getParser().parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String toString() {
        return this.name;
    }

    public static GTFField fromString(String str) {
        str = str.toLowerCase();
        for (GTFField c : GTFField.values()) {
            if (!c.name.equals(str)) continue;
            return c;
        }
        return null;
    }

    static {
        GTF_FIELD_NAMES = Arrays.stream(GTFField.values()).map(GTFField::getName).collect(Collectors.toSet());
    }
}

