/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.isa.liquidsvm.gui;

import de.unistuttgart.isa.liquidsvm.Config;
import de.unistuttgart.isa.liquidsvm.LiquidData;
import de.unistuttgart.isa.liquidsvm.SVM;
import de.unistuttgart.isa.liquidsvm.gui.CommandLineArgument;
import de.unistuttgart.isa.liquidsvm.gui.Param;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class SVMFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JTextField outputTextfield;
    private JPanel argumentsPanel;
    private JPanel configPanel;
    private SVM svm;
    private Config configuration = new Config();
    private Map<CommandLineArgument, List<JComponent>> commandArgsComps = new TreeMap<CommandLineArgument, List<JComponent>>();
    private Map<CommandLineArgument, JCheckBox> commandArgUseCBs = new TreeMap<CommandLineArgument, JCheckBox>();
    private Map<ConfigOption, JComponent> configComps = new TreeMap<ConfigOption, JComponent>();
    private Map<ConfigOption, JCheckBox> configUseCBs = new TreeMap<ConfigOption, JCheckBox>();
    private JComboBox<String> dataComboBox;
    private JComboBox<Scenario> scenarioComboBox;

    public static void main(String[] args) {
        System.setProperty("enable.load.without.library", "true");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SVMFrame frame = new SVMFrame();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public SVMFrame() {
        this.layoutComponents();
        this.layoutConfigOptions();
        this.layoutParameters();
        this.makeSVM();
    }

    public double[][] getTrainData() {
        return LiquidData.iris;
    }

    public double[] getTrainDataLabels() {
        return LiquidData.iris_labs;
    }

    public double[][] getTestData() {
        return LiquidData.iris;
    }

    public double[] getTestDataLabels() {
        return LiquidData.iris_labs;
    }

    private void makeSVM() {
        this.svm = ((Scenario)((Object)this.scenarioComboBox.getSelectedItem())).createSVM(this.getTrainData(), this.getTrainDataLabels(), this.configuration.train(false));
    }

    private void layoutParameters() {
        this.argumentsPanel.setLayout(new GridLayout(0, 1));
        for (CommandLineArgument conf : CommandLineArgument.values()) {
            ArrayList<JComponent> comps = new ArrayList<JComponent>();
            JPanel pan = new JPanel(new FlowLayout(0));
            final JCheckBox useCheckbox = new JCheckBox();
            pan.add(useCheckbox);
            this.commandArgUseCBs.put(conf, useCheckbox);
            pan.add(new JLabel(conf.name() + ": -" + conf.character + " "));
            for (Param param : conf.params) {
                String name = param.name;
                String type = param.type;
                JComponent comp = null;
                if (type == null) {
                    comp = new JTextField(5);
                    ((JTextComponent)comp).getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            useCheckbox.setSelected(true);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            useCheckbox.setSelected(true);
                        }

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            useCheckbox.setSelected(true);
                        }
                    });
                } else if (type.startsWith("&")) {
                    String[] split = type.split("&");
                    JComboBox<String> jc = new JComboBox<String>(split);
                    ((MutableComboBoxModel)jc.getModel()).removeElementAt(0);
                    if (type.contains("&*")) {
                        for (String s : split) {
                            if (!s.startsWith("*")) continue;
                            jc.setSelectedItem(s);
                        }
                    }
                    jc.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            useCheckbox.setSelected(true);
                            SVMFrame.this.updateOutput();
                        }
                    });
                    comp = jc;
                } else if (type.contains(":")) {
                    SpinnerNumberModel sm;
                    Object[] arr;
                    if (type.endsWith(":")) {
                        type = type + 1000;
                    }
                    if ((arr = type.split(":")).length != 3) {
                        sm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
                        System.err.println("Problem parsing: " + type + " => " + Arrays.toString(arr));
                    } else {
                        int[] numbers = new int[3];
                        for (int i = 0; i < 3; ++i) {
                            numbers[i] = arr[i].length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(arr[i]);
                        }
                        sm = new SpinnerNumberModel(numbers[1], numbers[0], numbers[2], 1);
                    }
                    JSpinner js = new JSpinner(sm);
                    comp = js;
                    js.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            useCheckbox.setSelected(true);
                            SVMFrame.this.updateOutput();
                        }
                    });
                } else {
                    comp = new JTextField(type);
                }
                pan.add(new JLabel("<" + name + ">: "));
                pan.add(comp);
                comps.add(comp);
                comp.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        SVMFrame.this.updateOutput();
                    }
                });
            }
            useCheckbox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SVMFrame.this.updateOutput();
                }
            });
            this.argumentsPanel.add(pan);
            this.commandArgsComps.put(conf, comps);
        }
    }

    private void layoutConfigOptions() {
        this.configPanel.setLayout(new GridLayout(0, 1));
        for (ConfigOption conf : ConfigOption.values()) {
            JPanel pan = new JPanel(new FlowLayout(0));
            final JCheckBox useCheckbox = new JCheckBox();
            pan.add(useCheckbox);
            this.configUseCBs.put(conf, useCheckbox);
            pan.add(new JLabel(conf.name() + " = "));
            String type = conf.paramType;
            JComponent comp = null;
            if (type == null) {
                comp = new JTextField(5);
                comp.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        useCheckbox.setSelected(true);
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        useCheckbox.setSelected(true);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        useCheckbox.setSelected(true);
                    }
                });
            } else if (type.startsWith("&")) {
                String[] split = type.split("&");
                JComboBox<String> jc = new JComboBox<String>(split);
                ((MutableComboBoxModel)jc.getModel()).removeElementAt(0);
                if (type.contains("&*")) {
                    for (String s : split) {
                        if (!s.startsWith("*")) continue;
                        jc.setSelectedItem(s);
                    }
                }
                jc.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        useCheckbox.setSelected(true);
                        SVMFrame.this.updateOutput();
                    }
                });
                comp = jc;
            } else if (type.contains(":")) {
                SpinnerNumberModel sm;
                Object[] arr;
                if (type.endsWith(":")) {
                    type = type + 1000;
                }
                if ((arr = type.split(":")).length != 3) {
                    sm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
                    System.err.println("Problem parsing: " + type + " => " + Arrays.toString(arr));
                } else {
                    int[] numbers = new int[3];
                    for (int i = 0; i < 3; ++i) {
                        numbers[i] = arr[i].length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(arr[i]);
                    }
                    sm = new SpinnerNumberModel(numbers[1], numbers[0], numbers[2], 1);
                }
                JSpinner js = new JSpinner(sm);
                comp = js;
                js.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        useCheckbox.setSelected(true);
                        SVMFrame.this.updateOutput();
                    }
                });
            } else {
                comp = new JTextField(type);
            }
            pan.add(comp);
            comp.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SVMFrame.this.updateOutput();
                }
            });
            useCheckbox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SVMFrame.this.updateOutput();
                }
            });
            this.configPanel.add(pan);
            this.configComps.put(conf, comp);
        }
    }

    protected String[] updateOutput() {
        ArrayList args = new ArrayList();
        this.configuration = new Config();
        for (ConfigOption configOption : ConfigOption.values()) {
            JTextField tf;
            if (!this.configUseCBs.get((Object)configOption).isSelected()) continue;
            String type = configOption.paramType;
            JComponent comp = this.configComps.get((Object)configOption);
            String value = null;
            if (type == null) {
                tf = (JTextField)comp;
                value = tf.getText();
            } else if (type.startsWith("&")) {
                String[] split = type.split("&");
                if (!(comp instanceof JComboBox)) continue;
                JComboBox jc = (JComboBox)comp;
                String sel = (String)jc.getSelectedItem();
                int start = 0;
                if (sel.startsWith("*")) {
                    start = 1;
                }
                value = sel.substring(start, sel.indexOf(58));
            } else if (type.contains(":")) {
                SpinnerNumberModel sm;
                Object[] arr;
                if (type.endsWith(":")) {
                    type = type + 1000;
                }
                if ((arr = type.split(":")).length != 3) {
                    sm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
                    System.err.println("Problem parsing: " + type + " => " + Arrays.toString(arr));
                } else {
                    int[] numbers = new int[3];
                    for (int i = 0; i < 3; ++i) {
                        numbers[i] = arr[i].length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(arr[i]);
                    }
                    sm = new SpinnerNumberModel(numbers[1], numbers[0], numbers[2], 1);
                }
                JSpinner js = (JSpinner)comp;
                value = js.getValue().toString();
            } else {
                tf = (JTextField)comp;
                value = tf.getText();
            }
            this.configuration.set(configOption.name(), value);
        }
        this.parseCommandArgsFromConfig();
        for (Enum enum_ : CommandLineArgument.values()) {
            if (!this.commandArgUseCBs.get(enum_).isSelected()) continue;
            ArrayList<String> localargs = new ArrayList<String>();
            localargs.add("-" + ((CommandLineArgument)enum_).character);
            boolean tainted = false;
            Iterator<JComponent> iterator = this.commandArgsComps.get(enum_).iterator();
            for (Param param : ((CommandLineArgument)enum_).params) {
                String text;
                JTextField tf;
                String type = param.type;
                JComponent comp = iterator.next();
                if (type == null) {
                    tf = (JTextField)comp;
                    text = tf.getText();
                    if (text.length() <= 0) continue;
                    localargs.add(text);
                    tainted = true;
                    continue;
                }
                if (type.startsWith("&")) {
                    String[] split = type.split("&");
                    if (!(comp instanceof JComboBox)) continue;
                    JComboBox jc = (JComboBox)comp;
                    String sel = (String)jc.getSelectedItem();
                    int start = 0;
                    if (sel.startsWith("*")) {
                        start = 1;
                    } else {
                        tainted = true;
                    }
                    localargs.add(sel.substring(start, sel.indexOf(58)));
                    continue;
                }
                if (type.contains(":")) {
                    SpinnerNumberModel sm;
                    Object[] arr;
                    if (type.endsWith(":")) {
                        type = type + 1000;
                    }
                    if ((arr = type.split(":")).length != 3) {
                        sm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
                        System.err.println("Problem parsing: " + type + " => " + Arrays.toString(arr));
                    } else {
                        int[] numbers = new int[3];
                        for (int i = 0; i < 3; ++i) {
                            numbers[i] = arr[i].length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(arr[i]);
                        }
                        sm = new SpinnerNumberModel(numbers[1], numbers[0], numbers[2], 1);
                    }
                    JSpinner js = (JSpinner)comp;
                    String val = js.getValue().toString();
                    localargs.add(val);
                    if (type.contains(":" + val + ":")) continue;
                    tainted = true;
                    continue;
                }
                tf = (JTextField)comp;
                text = tf.getText();
                localargs.add(text);
                if (type.equals(text)) continue;
                tainted = true;
            }
            args.addAll(localargs);
        }
        this.outputTextfield.setText(((Object)args).toString());
        return args.toArray(new String[args.size()]);
    }

    private void parseCommandArgsFromConfig() {
        this.svm.setConfigAll(this.configuration);
        for (CommandLineArgument conf : CommandLineArgument.values()) {
            if (!this.commandArgUseCBs.get((Object)conf).isSelected()) continue;
        }
    }

    public void layoutComponents() {
        this.setDefaultCloseOperation(3);
        this.setBounds(10, 10, 1200, 900);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel headPanel = new JPanel();
        JLabel lblData = new JLabel("Data:");
        this.dataComboBox = new JComboBox();
        this.dataComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Iris", "Trees", "CovType"}));
        JLabel lblSolver = new JLabel("Scenario:");
        this.scenarioComboBox = new JComboBox();
        this.scenarioComboBox.setModel(new DefaultComboBoxModel<Scenario>(Scenario.values()));
        GroupLayout gl_headPanel = new GroupLayout(headPanel);
        gl_headPanel.setHorizontalGroup(gl_headPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_headPanel.createSequentialGroup().addGap(5).addComponent(lblData).addGap(5).addComponent(this.dataComboBox, -2, -1, -2).addGap(5).addComponent(lblSolver).addGap(5).addComponent(this.scenarioComboBox, -2, -1, -2)));
        gl_headPanel.setVerticalGroup(gl_headPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_headPanel.createSequentialGroup().addGap(10).addComponent(lblData)).addGroup(gl_headPanel.createSequentialGroup().addGap(5).addComponent(this.dataComboBox, -2, -1, -2)).addGroup(gl_headPanel.createSequentialGroup().addGap(10).addComponent(lblSolver)).addGroup(gl_headPanel.createSequentialGroup().addGap(5).addComponent(this.scenarioComboBox, -2, -1, -2)));
        headPanel.setLayout(gl_headPanel);
        this.contentPane.add((Component)headPanel, "North");
        JPanel outputPanel = new JPanel();
        this.contentPane.add((Component)outputPanel, "South");
        outputPanel.setLayout(new BorderLayout(0, 0));
        this.outputTextfield = new JTextField("Output");
        outputPanel.add(this.outputTextfield);
        this.outputTextfield.setColumns(10);
        this.outputTextfield.setEditable(false);
        outputPanel.add("East", new JButton(new AbstractAction("SVM!"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SVM svm = ((Scenario)((Object)SVMFrame.this.scenarioComboBox.getSelectedItem())).createSVM(LiquidData.iris, LiquidData.iris_labs, SVMFrame.this.configuration.train(false));
                svm.train(SVMFrame.this.updateOutput());
                svm.select(new String[0]);
                svm.test(LiquidData.iris, LiquidData.iris_labs, new String[0]);
            }
        }));
        this.configPanel = new JPanel();
        this.argumentsPanel = new JPanel();
        JScrollPane argumentsScroll = new JScrollPane(this.argumentsPanel, 20, 30);
        JSplitPane split = new JSplitPane(1, true, this.configPanel, argumentsScroll);
        split.setOneTouchExpandable(true);
        this.contentPane.add((Component)split, "Center");
    }

    public static enum ConfigOption {
        Display("0:1:4", "How much information should there be printed."),
        Threads("-1:0:" + SVM.MAX_CPU, "How many threads should be used"),
        Partition_choice("&*0:do not split the working sets&1:split random chunks using maximum <size> of each chunk&2:split the working sets in random chunks using <number> of chunks&3:split by Voronoi subsets using <radius>&4:split by Voronoi subsets of some <size>.&5:split by Voronoi subsets <size> with overlaps.&6:split by Voronoi subsets using <size> (faster).", "What Partitioning should be used."),
        Grid_choice("-2:0:2", " What Grid configuration should be used"),
        Folds("1:5:", "How many folds should be used in cross-validation"),
        Kernel("&*0:Gaussian RBF&1:Poisson", "What kernel to use");

        public String paramType;
        public String help;

        private ConfigOption(String paramType, String help) {
            this.paramType = paramType;
            this.help = help;
        }
    }

    public static enum Scenario {
        LS(SVM.LS.class),
        MC(SVM.MC.class),
        QT(SVM.QT.class),
        EX(SVM.EX.class),
        NPL(SVM.NPL.class),
        ROC(SVM.ROC.class);

        public final Class type;

        private Scenario(Class type) {
            this.type = type;
        }

        SVM createSVM(double[][] data, double[] labels, Config config) {
            return new SVM(this.name(), data, labels, config);
        }
    }
}

