/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.isa.liquidsvm.gui;

import de.unistuttgart.isa.liquidsvm.SVM;
import de.unistuttgart.isa.liquidsvm.gui.Param;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public enum CommandLineArgument {
    Display("-d <level>", "0:1:4"),
    Folds("-f <kind> <number> [<train_fraction>] [<neg_fraction>]", "&1:each fold is a contiguous block&2:alternating fold assignment&*3:random&4:stratified random&5:random subset (<train_fraction> and <neg_fraction> required)", "1:5:"),
    Gamma("-g <size> <min_gamma> <max_gamma> [<scale>]", "1:10:", "1.0", "5.0"),
    Gpu("-GPU <gpus>", "0:0:"),
    Help("-h [<level>]", "&*0:short help messages&1:detailed help messages"),
    Initialization("-i <cold> <warm>", "0:0:6", "0:0:6"),
    Kernel("-k <type> [<tmmp> [sizep] <tmm> [size] <vmmp> <vmm>]", "&*0:Gaussian RBF&1:Poisson"),
    Lambda("-l <size> <min_lambda> <max_lambda> [<scale>]", "1:10:", null, null, "&0:no scaling, i.e. keep <min_lambda> as its is&*1:devide <min_lambda> by <samples in fold>"),
    Loss("-L <loss> [<neg_weight> <pos_weight>]", "&0:binary classification loss&2:least squares loss&3:weighted least squares loss"),
    Partitioning("-P <type> [<number/radius/size> [subset_size]]", "&*0:do not split the working sets&1:split the working sets in random chunks using maximum <size> of each chunk&2:split the working sets in random chunks using <number> of chunks&3:split the working sets by Voronoi subsets using <radius>&4:split the working sets by Voronoi subsets using <size>."),
    RandomSeed("-r <seed>", "-1:-1:2147483647"),
    Clipp("-s <clipp> [<stop_eps>]", "-1.0", "0.0010"),
    Threads("-T <threads>", "-1:0:" + SVM.MAX_CPU),
    Weights("-w <weight1> <weight2> [<weights> <geometric> <class>]", new String[0]),
    Workingset("-W <type>", "&*0:take the entire data set&1:multiclass 'all versus all'&2:multiclass 'one versus all'&3:bootstrap with <number> resamples of size <size>");

    private static Set<String> names;
    public String character;
    public String paramDescription;
    public List<Param> params = new ArrayList<Param>();

    private CommandLineArgument(String paramDescription, String ... types) {
        this.paramDescription = paramDescription;
        String[] arr = paramDescription.split(" ");
        this.character = arr[0].substring(1);
        int optional = 0;
        for (int i = 1; i < arr.length; ++i) {
            String s;
            String name = s = arr[i];
            if (s.startsWith("[")) {
                name = s.substring(1);
                ++optional;
            }
            if (s.endsWith("]")) {
                name = name.substring(0, name.length() - 1);
            }
            if (name.startsWith("<")) {
                name = name.substring(1, name.length() - 1);
            }
            String type = null;
            if (i - 1 < types.length) {
                type = types[i - 1];
            }
            this.params.add(new Param(name, type, optional));
            if (!s.endsWith("]")) continue;
            --optional;
        }
    }

    private CommandLineArgument(String character, List<Param> params) {
        this.character = character;
        this.params = params;
    }

    public String toString() {
        return this.name() + " [-" + this.character + "]: " + this.params;
    }

    public static Set<String> getNames() {
        if (names == null) {
            names = new TreeSet<String>();
            for (CommandLineArgument c : CommandLineArgument.values()) {
                for (Param p : c.params) {
                    names.add(p.name);
                }
            }
        }
        return names;
    }
}

