/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.isa.liquidsvm;

import de.unistuttgart.isa.liquidsvm.Config;
import de.unistuttgart.isa.liquidsvm.LiquidData;
import de.unistuttgart.isa.liquidsvm.ResultAndErrors;
import de.unistuttgart.isa.liquidsvm.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Map;

public class SVM
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Object LOCK;
    public static boolean ENABLE_LOAD_WITHOUT_LIBRARY;
    private transient int cookie;
    private boolean trained = false;
    private boolean selected = false;
    private int errors_count;
    private double[][] train_errs;
    private double[][] select_errs;
    private ResultAndErrors lastResult;
    public static final int MAX_CPU;

    public double[][] getTrainErrs() {
        return this.train_errs;
    }

    public double[][] getSelectErrs() {
        return this.select_errs;
    }

    public ResultAndErrors getLastResult() {
        return this.lastResult;
    }

    int getCookie() {
        return this.cookie;
    }

    public SVM() {
        this("LS", LiquidData.trees, LiquidData.trees_labs, null);
    }

    private SVM(int cookie) {
        this.cookie = cookie;
    }

    public SVM(String scenario, double[][] data, double[] labels, Config config) {
        this(scenario, data, labels, config, false);
    }

    public SVM(String scenario, LiquidData.Data data, Config config) {
        this(scenario, data.x, data.y, config, false);
    }

    public SVM(String scenario, LiquidData data, Config config) {
        this(scenario, data.train.x, data.train.y, config, false);
        this.test(data.test.x, data.test.y, new String[0]);
    }

    private SVM(String scenario, double[][] data, double[] labels, Config config, boolean waitAuto) {
        double[] dataArr = SVM.matrix2array(data);
        if (labels == null) {
            throw new NullPointerException("Labels are null");
        }
        if (labels.length != data.length) {
            throw new IllegalArgumentException("Data and Labels have to be of the same size");
        }
        this.cookie = SVM.svm_init(dataArr, labels);
        if (this.getCookie() < 0) {
            throw new RuntimeException("Problem in svm_init!");
        }
        this.setConfig("D", 1);
        this.setConfig("CONFIG_DEBUG", 1);
        this.setConfig("SCENARIO", scenario);
        this.setConfigAll(config);
        if (!waitAuto) {
            this.doTrainSelect(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[][] train(String ... argv) {
        this.train_errs = null;
        Object object = LOCK;
        synchronized (object) {
            argv = this.configure(1, argv);
            double[] ret = SVM.svm_train(this.getCookie(), argv);
            this.train_errs = ResultAndErrors.myconvert(ret);
            if (this.train_errs == null) {
                throw new RuntimeException("Problem in train");
            }
            this.trained = true;
            this.select_errs = null;
        }
        return this.train_errs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[][] select(String ... argv) {
        if (!this.trained) {
            throw new IllegalStateException("SVM has not been trained yet.");
        }
        Object object = LOCK;
        synchronized (object) {
            argv = this.configure(2, argv);
            double[] ret = SVM.svm_select(this.getCookie(), argv);
            double[][] select_errs_ret = ResultAndErrors.myconvert(ret);
            if (select_errs_ret == null) {
                throw new RuntimeException("Problem in select");
            }
            double[][] select_errs_old = this.select_errs;
            if (select_errs_old != null && select_errs_old.length > 0) {
                this.select_errs = new double[select_errs_old.length + select_errs_ret.length][];
                System.arraycopy(select_errs_old, 0, this.select_errs, 0, select_errs_old.length);
                System.arraycopy(select_errs_ret, 0, this.select_errs, select_errs_old.length, select_errs_ret.length);
            } else {
                this.select_errs = select_errs_ret;
            }
            this.selected = true;
        }
        return this.select_errs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] predict(double[][] test, String ... argv) {
        Object object = LOCK;
        synchronized (object) {
            double[] labs = null;
            double[][] result = this.test((double[][])test, labs, (String[])argv).result;
            double[] ret = new double[test.length];
            for (int i = 0; i < ret.length && i < result.length; ++i) {
                ret[i] = result[i][0];
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultAndErrors test(double[][] test, double[] labs, String ... argv) {
        if (!this.selected) {
            throw new IllegalStateException("SVM has not been selected yet.");
        }
        Object object = LOCK;
        synchronized (object) {
            argv = this.configure(3, argv);
            ResultAndErrors predictions = SVM.svm_test(this.getCookie(), argv, test.length, SVM.matrix2array(test), labs, new ResultAndErrors());
            if (predictions.result == null) {
                throw new RuntimeException("Problem in test");
            }
            this.lastResult = predictions;
            return predictions;
        }
    }

    public ResultAndErrors test(LiquidData.Data test, String ... argv) {
        return this.test(test.x, test.y, new String[0]);
    }

    public void clean() {
        if (this.getCookie() < 0) {
            throw new IllegalStateException("SVM cannot be cleaned since there is nothing to clean!");
        }
        SVM.svm_clean(this.getCookie());
    }

    protected void finalize() throws Throwable {
        if (this.getCookie() >= 0) {
            SVM.svm_clean(this.getCookie());
        }
        super.finalize();
    }

    private static native int[] svm_cover_dataset(int var0, int var1, double[] var2);

    public static double[][] calculateDataCover(int NNs, double[][] data) {
        if (data.length == 0) {
            return new double[0][];
        }
        int dim = data[0].length;
        if (dim == 0) {
            return new double[0][0];
        }
        double[] tmp = new double[data.length * dim];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(data[i], 0, tmp, i * dim, dim);
        }
        int[] centers = SVM.svm_cover_dataset(NNs, dim, tmp);
        double[][] ret = new double[centers.length][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = data[centers[i]];
        }
        return ret;
    }

    static native String default_params(int var0, int var1);

    private static native int svm_init(double[] var0, double[] var1);

    private static native double[] svm_train(int var0, String[] var1);

    private static native double[] svm_select(int var0, String[] var1);

    private static native ResultAndErrors svm_test(int var0, String[] var1, int var2, double[] var3, double[] var4, ResultAndErrors var5);

    private static native void svm_clean(int var0);

    private static native void set_param(int var0, String var1, String var2);

    private static native String get_param(int var0, String var1);

    private static native String get_config_line(int var0, int var1);

    public SVM setConfig(String name, String value) {
        SVM.set_param(this.getCookie(), name.toUpperCase(), value);
        return this;
    }

    public SVM setConfig(String name, int value) {
        this.setConfig(name, Integer.toString(value));
        return this;
    }

    public SVM setConfig(String name, double value) {
        this.setConfig(name, Double.toString(value));
        return this;
    }

    public SVM setConfig(String name, double[] value) {
        if (value == null || value.length == 0) {
            return this;
        }
        StringBuilder s = new StringBuilder(Double.toString(value[0]));
        for (int i = 1; i < value.length; ++i) {
            s.append(" ").append(value[i]);
        }
        this.setConfig(name, s.toString());
        return this;
    }

    public SVM setConfigAll(Config config) {
        if (config == null) {
            return this;
        }
        for (Map.Entry<String, String> kv : config.entries()) {
            this.setConfig(kv.getKey(), kv.getValue());
        }
        return this;
    }

    public String getConfig(String name) {
        return SVM.get_param(this.getCookie(), name.toUpperCase());
    }

    private String getConfigLine(int stage) {
        return SVM.get_config_line(this.getCookie(), stage);
    }

    private static double[] matrix2array(double[][] matrix) {
        int n = matrix.length;
        if (n == 0) {
            throw new IllegalArgumentException("Matrix with 0 rows not allowed.");
        }
        int dim = matrix[0].length;
        double[] ret = new double[n * dim];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < dim; ++j) {
                ret[i * dim + j] = matrix[i][j];
            }
        }
        return ret;
    }

    private String[] configure(int stage, String ... argv) {
        Object[] config_line = this.getConfigLine(stage).trim().split(" ");
        System.out.println(Arrays.toString(config_line));
        Object[] ret = new String[1 + config_line.length + argv.length];
        ret[0] = "liquidsvm";
        System.arraycopy(config_line, 0, ret, 1, config_line.length);
        System.arraycopy(argv, 0, ret, 1 + config_line.length, argv.length);
        System.out.println(Arrays.toString(ret));
        return ret;
    }

    private void doTrainSelect(Config config) {
        if (config == null || config.isAutoTrain()) {
            this.train(new String[0]);
            if (config == null || config.isAutoSelect()) {
                this.select(new String[0]);
            }
        }
    }

    public boolean isTrained() {
        return this.trained;
    }

    public boolean isSelected() {
        return this.selected;
    }

    private static native int[] svm_get_cover(int var0, int var1);

    public int[] getCover(int task) {
        if (!this.trained) {
            throw new IllegalStateException("SVM has not been trained yet.");
        }
        if (task < 0) {
            throw new IllegalArgumentException("task has to be >= 0");
        }
        return SVM.svm_get_cover(this.cookie, task);
    }

    private static native int[] svm_get_solution_svs(int var0, int var1, int var2, int var3);

    public int[] getSolutionSVs(int task, int cell, int fold) {
        if (!this.selected) {
            throw new IllegalStateException("SVM has not been selected yet.");
        }
        if (task <= 0 || cell <= 0 || fold <= 0) {
            throw new IllegalArgumentException("task, cell, and fold have to be >= 1");
        }
        return SVM.svm_get_solution_svs(fold, task, cell, fold);
    }

    private static native double[] svm_get_solution_coeffs(int var0, int var1, int var2, int var3);

    public double[] getSolutionCoeffs(int task, int cell, int fold) {
        if (!this.selected) {
            throw new IllegalStateException("SVM has not been selected yet.");
        }
        return SVM.svm_get_solution_coeffs(fold, task, cell, fold);
    }

    private static native void svm_write_solution(int var0, String var1);

    private void writeSVM(String filename) {
        if (!filename.endsWith(".sol") && !filename.endsWith(".fsol")) {
            throw new IllegalArgumentException("Filename must have extension .fsol or .sol.");
        }
        if (!new File(filename).canWrite()) {
            throw new IllegalArgumentException("File must be writable.");
        }
        SVM.svm_write_solution(this.cookie, filename);
    }

    private static native int svm_read_solution(int var0, String var1);

    public int readSVM(String filename) {
        if (!filename.endsWith(".sol") && !filename.endsWith(".fsol")) {
            throw new IllegalArgumentException("Filename must have extension .fsol or .sol.");
        }
        if (!new File(filename).canRead()) {
            throw new IllegalArgumentException("File must be readable.");
        }
        this.cookie = SVM.svm_read_solution(-1, filename);
        return this.cookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        File tmp = File.createTempFile("solution", ".fsol");
        tmp.deleteOnExit();
        this.writeSVM(tmp.getAbsolutePath());
        FileInputStream file = new FileInputStream(tmp);
        try {
            int len;
            long filelen;
            out.writeLong(filelen);
            byte[] buffer = new byte[10240];
            for (filelen = tmp.length(); (len = file.read(buffer)) >= 0 && filelen > 0L; filelen -= (long)len) {
                out.write(buffer, 0, len);
            }
            if (filelen > 0L) {
                throw new IOException("Error copying file to stream: bytes still promised " + filelen + " but stream ended");
            }
            if (len >= 0) {
                throw new IOException("Error copying file to stream: already read all promised bytes but last read was not end of file stream");
            }
            out.defaultWriteObject();
        }
        finally {
            try {
                file.close();
            }
            finally {
                tmp.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        File tmp = File.createTempFile("solution", ".fsol");
        tmp.deleteOnExit();
        FileOutputStream file = new FileOutputStream(tmp);
        try {
            int len;
            byte[] buffer = new byte[10240];
            for (long filelen = in.readLong(); filelen > 0L; filelen -= (long)len) {
                len = in.read(buffer, 0, (int)Math.min((long)buffer.length, filelen));
                if (len < 0) {
                    throw new IOException("End of stream but still expected " + filelen + " bytes");
                }
                file.write(buffer, 0, len);
            }
            int newCookie = this.readSVM(tmp.getAbsolutePath());
            in.defaultReadObject();
            this.cookie = newCookie;
            this.selected = true;
            this.trained = true;
        }
        finally {
            try {
                file.close();
            }
            finally {
                tmp.delete();
            }
        }
    }

    static {
        block6: {
            LOCK = new Integer(0);
            ENABLE_LOAD_WITHOUT_LIBRARY = false;
            String filename = Util.sharedLibraryName();
            try {
                try {
                    System.loadLibrary("liquidsvm");
                }
                catch (UnsatisfiedLinkError e) {
                    try {
                        System.out.println(SVM.class.getResource("."));
                        System.out.println(SVM.class.getResource("/" + filename));
                        InputStream source = SVM.class.getResourceAsStream("/" + filename);
                        int pos = filename.lastIndexOf(46);
                        File file = File.createTempFile(filename.substring(0, pos), filename.substring(pos));
                        file.deleteOnExit();
                        Files.copy(source, Paths.get(file.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        System.load(file.getAbsolutePath());
                    }
                    catch (IOException ex) {
                        throw new UnsatisfiedLinkError("Could not use pre-built lib: " + ex.getMessage());
                    }
                }
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("library liquidsvm could not be loaded. Probably it could not be found.\n\nAdd its directory either with:\n    java -Djava.library.path=path/to/dir of " + filename + "\nor change the environment variable:\n    " + Util.LD_LIBRARY_NAME() + "\n\nCurrent java.library.path is " + System.getProperty("java.library.path"));
                if (System.getProperty("enable.load.without.library").equals("true")) break block6;
                throw e;
            }
        }
        MAX_CPU = Runtime.getRuntime().availableProcessors();
    }

    public static class EX
    extends SVM {
        public static final double[] DEFAULT_WEIGHTS = new double[]{0.05, 0.1, 0.5, 0.9, 0.95};
        private double[] weights;

        public EX(LiquidData data) {
            this(data, DEFAULT_WEIGHTS, null);
        }

        public EX(LiquidData data, double[] weights) {
            this(data, weights, null);
        }

        public EX(LiquidData data, double[] weights, Config config) {
            this(data.train, weights, config);
            this.test(data.test, new String[0]);
        }

        public EX(LiquidData.Data data) {
            this(data, DEFAULT_WEIGHTS, null);
        }

        public EX(LiquidData.Data data, double[] weights) {
            this(data, weights, null);
        }

        public EX(LiquidData.Data data, double[] weights, Config config) {
            this(data.x, data.y, weights, config);
        }

        public EX(double[][] data, double[] labels) {
            this(data, labels, DEFAULT_WEIGHTS, null);
        }

        public EX(double[][] data, double[] labels, double[] weights) {
            this(data, labels, weights, null);
        }

        public EX(double[][] data, double[] labels, double[] weights, Config config) {
            super("EX", data, labels, config, true);
            this.init(weights, config);
        }

        private void init(double[] weights, Config config) {
            this.weights = weights;
            this.setConfig("weights", weights);
            ((SVM)this).doTrainSelect(config);
        }

        @Override
        public double[][] select(String ... argv) {
            double[][] ret = null;
            for (int i = 1; i <= this.weights.length; ++i) {
                this.setConfig("weight_number", i);
                ret = super.select(argv);
            }
            return ret;
        }
    }

    public static class QT
    extends SVM {
        public static final double[] DEFAULT_WEIGHTS = new double[]{0.05, 0.1, 0.5, 0.9, 0.95};
        private double[] weights;

        public QT(LiquidData data) {
            this(data, DEFAULT_WEIGHTS);
        }

        public QT(LiquidData data, double[] weights) {
            this(data, weights, null);
        }

        public QT(LiquidData data, double[] weights, Config config) {
            this(data.train, weights, config);
            this.test(data.test, new String[0]);
        }

        public QT(LiquidData.Data data) {
            this(data, DEFAULT_WEIGHTS);
        }

        public QT(LiquidData.Data data, double[] weights) {
            this(data, weights, null);
        }

        public QT(LiquidData.Data data, double[] weights, Config config) {
            this(data.x, data.y, weights, config);
        }

        public QT(double[][] data, double[] labels) {
            this(data, labels, DEFAULT_WEIGHTS);
        }

        public QT(double[][] data, double[] labels, double[] weights) {
            this(data, labels, weights, null);
        }

        public QT(double[][] data, double[] labels, double[] weights, Config config) {
            super("QT", data, labels, config, true);
            this.init(weights, config);
        }

        private void init(double[] weights, Config config) {
            this.weights = weights;
            this.setConfig("weights", weights);
            ((SVM)this).doTrainSelect(config);
        }

        @Override
        public double[][] select(String ... argv) {
            double[][] ret = null;
            for (int i = 1; i <= this.weights.length; ++i) {
                this.setConfig("weight_number", i);
                System.out.println(this.getConfig("weight_number"));
                ret = super.select(argv);
            }
            return ret;
        }
    }

    public static class LS
    extends SVM {
        public LS(LiquidData data) {
            this(data, -1.0, null);
        }

        public LS(LiquidData data, Config config) {
            this(data, -1.0, config);
        }

        public LS(LiquidData data, double clipping) {
            this(data, clipping, null);
        }

        public LS(LiquidData data, double clipping, Config config) {
            this(data.train, config);
            this.test(data.test, new String[0]);
        }

        public LS(LiquidData.Data data) {
            this(data, -1.0, null);
        }

        public LS(LiquidData.Data data, Config config) {
            this(data, -1.0, config);
        }

        public LS(LiquidData.Data data, double clipping) {
            this(data, clipping, null);
        }

        public LS(LiquidData.Data data, double clipping, Config config) {
            this(data.x, data.y, clipping, config);
        }

        public LS(double[][] data, double[] labels) {
            this(data, labels, -1.0, null);
        }

        public LS(double[][] data, double[] labels, Config config) {
            this(data, labels, -1.0, config);
        }

        public LS(double[][] data, double[] labels, double clipping) {
            this(data, labels, clipping, null);
        }

        public LS(double[][] data, double[] labels, double clipping, Config config) {
            super("LS " + clipping, data, labels, config);
        }
    }

    public static class ROC
    extends SVM {
        private int weightSteps;

        public ROC(LiquidData data) {
            this(data, 9, null);
        }

        public ROC(LiquidData data, int weightSteps) {
            this(data, weightSteps, null);
        }

        public ROC(LiquidData data, int weightSteps, Config config) {
            this(data.train, weightSteps, config);
            this.test(data.test, new String[0]);
        }

        public ROC(LiquidData.Data data) {
            this(data, 9, null);
        }

        public ROC(LiquidData.Data data, int weightSteps) {
            this(data, weightSteps, null);
        }

        public ROC(LiquidData.Data data, int weightSteps, Config config) {
            this(data.x, data.y, weightSteps, config);
        }

        public ROC(double[][] data, double[] labels) {
            this(data, labels, 9, null);
        }

        public ROC(double[][] data, double[] labels, int weightSteps) {
            this(data, labels, weightSteps, null);
        }

        public ROC(double[][] data, double[] labels, int weightSteps, Config config) {
            super("ROC", data, labels, config, true);
            this.init(weightSteps, config);
        }

        private void init(int weightSteps, Config config) {
            this.weightSteps = weightSteps;
            this.setConfig("weight_steps", weightSteps);
            ((SVM)this).doTrainSelect(config);
        }

        @Override
        public double[][] select(String ... argv) {
            double[][] ret = null;
            for (int i = 1; i <= this.weightSteps; ++i) {
                this.setConfig("weight_number", i);
                ret = super.select(argv);
            }
            return ret;
        }
    }

    public static class NPL
    extends SVM {
        public static final double[] DEFAULT_CONSTRAINT_FACTORS = new double[]{0.5, 0.0, 1.0, 1.5, 2.0};
        private double constraint;
        private double[] constraintFactors;
        private double nplClass;

        public NPL(LiquidData data, double nplClass) {
            this(data, nplClass, 0.05);
        }

        public NPL(LiquidData data, double nplClass, double constraint) {
            this(data, nplClass, constraint, DEFAULT_CONSTRAINT_FACTORS, null);
        }

        public NPL(LiquidData data, double nplClass, double constraint, double[] constraintFactors, Config config) {
            this(data.train, nplClass, constraint, constraintFactors, config);
            this.test(data.test, new String[0]);
        }

        public NPL(LiquidData.Data data, double nplClass) {
            this(data, nplClass, 0.05);
        }

        public NPL(LiquidData.Data data, double nplClass, double constraint) {
            this(data, nplClass, constraint, DEFAULT_CONSTRAINT_FACTORS, null);
        }

        public NPL(LiquidData.Data data, double nplClass, double constraint, double[] constraintFactors, Config config) {
            this(data.x, data.y, nplClass, constraint, constraintFactors, config);
        }

        public NPL(double[][] data, double[] labels, double nplClass) {
            this(data, labels, nplClass, 0.05);
        }

        public NPL(double[][] data, double[] labels, double nplClass, double constraint) {
            this(data, labels, nplClass, constraint, DEFAULT_CONSTRAINT_FACTORS, null);
        }

        public NPL(double[][] data, double[] labels, double nplClass, double constraint, double[] constraintFactors, Config config) {
            super("NPL " + nplClass, data, labels, config, true);
            this.init(nplClass, constraint, constraintFactors, config);
        }

        private void init(double nplClass, double constraint, double[] constraintFactors, Config config) {
            this.nplClass = nplClass;
            this.constraint = constraint;
            this.constraintFactors = constraintFactors;
            ((SVM)this).doTrainSelect(config);
        }

        @Override
        public double[][] select(String ... argv) {
            double[][] ret = null;
            for (double cf : this.constraintFactors) {
                this.setConfig("npl_class", this.nplClass);
                this.setConfig("npl_constraint", this.constraint * cf);
                ret = super.select(argv);
            }
            return ret;
        }
    }

    public static class MC
    extends SVM {
        public MC(LiquidData data) {
            super("MC", data, null);
        }

        public MC(LiquidData data, Config config) {
            super("MC", data, config);
        }

        public MC(LiquidData data, String mcType) {
            this(data, mcType, null);
        }

        public MC(LiquidData data, String mcType, Config config) {
            super("MC " + mcType, data, config);
        }

        public MC(LiquidData.Data data) {
            super("MC", data, null);
        }

        public MC(LiquidData.Data data, Config config) {
            super("MC", data, config);
        }

        public MC(LiquidData.Data data, String mcType) {
            this(data, mcType, null);
        }

        public MC(LiquidData.Data data, String mcType, Config config) {
            super("MC " + mcType, data, config);
        }

        public MC(double[][] data, double[] labels) {
            super("MC", data, labels, null);
        }

        public MC(double[][] data, double[] labels, Config config) {
            super("MC", data, labels, config);
        }

        public MC(double[][] data, double[] labels, String mcType) {
            this(data, labels, mcType, null);
        }

        public MC(double[][] data, double[] labels, String mcType, Config config) {
            super("MC " + mcType, data, labels, config);
        }
    }
}

