/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.isa.liquidsvm;

import java.io.Serializable;
import java.util.Arrays;

public class ResultAndErrors
implements Serializable {
    public double[][] result = new double[0][];
    public double[][] errors = new double[0][];

    public ResultAndErrors() {
    }

    public ResultAndErrors(double[][] result, double[][] errors) {
        this.result = result;
        this.errors = errors;
    }

    public String toString() {
        String res = ResultAndErrors.matrixToString(this.result);
        String err = ResultAndErrors.matrixToString(this.errors);
        return "[ Result: " + res + ", Errors: " + err + " ]";
    }

    public static String matrixToString(double[][] arr) {
        if (arr == null) {
            return "null";
        }
        StringBuilder ret = new StringBuilder();
        ret.append(arr.length).append("x");
        if (arr.length > 0) {
            ret.append(arr[0].length).append(" ");
        }
        for (double[] row : arr) {
            ret.append(Arrays.toString(row)).append(" ");
        }
        return ret.toString();
    }

    private void setValues(double[] res, double[] err) {
        this.result = ResultAndErrors.myconvert(res);
        this.errors = ResultAndErrors.myconvert(err);
    }

    public static double[][] myconvert(double[] res) {
        if (res == null) {
            return null;
        }
        if (res.length == 0 || res[0] == 0.0) {
            return new double[0][];
        }
        int n = (int)res[0];
        int m = (int)res[1];
        double[][] ret = new double[n][m];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(res, 2 + i * m, ret[i], 0, m);
        }
        return ret;
    }
}

