/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.isa.liquidsvm;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Config
implements Serializable {
    private ArrayList<String> keys = new ArrayList();
    private HashMap<String, String> map = new HashMap();
    private boolean autoTrain = true;
    private boolean autoSelect = true;

    public Config() {
    }

    public Config(Config other) {
        this.keys = new ArrayList<String>(other.keys);
        this.map = new HashMap<String, String>(other.map);
        this.autoTrain = other.autoTrain;
        this.autoSelect = other.autoSelect;
    }

    public Config set(String key, String value) {
        this.keys.add(key);
        this.map.put(key, value);
        return this;
    }

    public String remove(Object key) {
        this.keys.remove(key);
        return this.map.remove(key);
    }

    public String get(String key) {
        return this.map.get(key);
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public List<Map.Entry<String, String>> entries() {
        LinkedList<Map.Entry<String, String>> ret = new LinkedList<Map.Entry<String, String>>();
        for (String s : this.keys) {
            ret.add(new AbstractMap.SimpleEntry<String, String>(s, this.map.get(s)));
        }
        return ret;
    }

    public Config scenario(String scenario) {
        return this.set("scenario", String.valueOf(scenario));
    }

    public Config display(int d) {
        return this.set("display", String.valueOf(d));
    }

    public Config threads(int d) {
        return this.set("threads", String.valueOf(d));
    }

    public Config partitionChoice(int d) {
        return this.set("partition_choice", String.valueOf(d));
    }

    public Config gridChoice(int d) {
        return this.set("grid_choice", String.valueOf(d));
    }

    public Config adaptivityControl(int d) {
        return this.set("adaptivity_control", String.valueOf(d));
    }

    public Config randomSeed(int d) {
        return this.set("random_seed", String.valueOf(d));
    }

    public Config folds(int d) {
        return this.set("folds", String.valueOf(d));
    }

    public Config voronoi(int d) {
        return this.set("voronoi", String.valueOf(d));
    }

    public Config scale(boolean d) {
        return this.set("scale", d ? "1" : "0");
    }

    public Config useCells() {
        return this.useCells(true);
    }

    public Config useCells(boolean b) {
        if (b) {
            return this.partitionChoice(6);
        }
        return this.partitionChoice(0);
    }

    public Config train(boolean b) {
        this.autoTrain = b;
        return this;
    }

    public Config select(boolean b) {
        this.autoSelect = b;
        return this;
    }

    public boolean isAutoTrain() {
        return this.autoTrain;
    }

    public boolean isAutoSelect() {
        return this.autoSelect;
    }
}

