/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil.export;

import de.unistuttgart.ims.uimautil.export.Column;
import de.unistuttgart.ims.uimautil.export.Datatype;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

public class MyFeaturePathColumn
extends Column {
    String featurePath;
    String[] pathParts;

    public MyFeaturePathColumn(String fp) {
        super(new String[]{fp});
        this.datatype = Datatype.STRING;
        this.featurePath = fp;
        if (this.featurePath.startsWith("/")) {
            this.featurePath = this.featurePath.substring(1);
        }
        this.pathParts = this.featurePath.split("/");
    }

    public MyFeaturePathColumn(String fp, String label) {
        super(new String[]{label});
        this.datatype = Datatype.STRING;
        this.featurePath = fp;
        if (this.featurePath.startsWith("/")) {
            this.featurePath = this.featurePath.substring(1);
        }
        this.pathParts = this.featurePath.split("/");
    }

    public Object getValue(TOP a) {
        return this.apply((FeatureStructure)a, this.pathParts);
    }

    public Object getValue(FeatureStructure a) {
        return this.apply(a, this.pathParts);
    }

    public boolean isMultiplying() {
        return false;
    }

    private Object getPrimitiveFunction(FeatureStructure fs, String function) {
        if (function.equalsIgnoreCase("coveredText()")) {
            return ((Annotation)fs).getCoveredText();
        }
        if (function.equalsIgnoreCase("type()")) {
            return fs.getType().getName();
        }
        return null;
    }

    private Object getPrimitive(FeatureStructure fs, Feature feature) {
        String s = feature.getRange().getName();
        if (s.equals("uima.cas.String")) {
            return fs.getStringValue(feature);
        }
        if (s.equals("uima.cas.Integer")) {
            return fs.getIntValue(feature);
        }
        if (s.equals("uima.cas.Double")) {
            return fs.getDoubleValue(feature);
        }
        return null;
    }

    private Object getPrimitiveComponent(FeatureStructure array, int index) {
        Type cType = array.getType().getComponentType();
        if (cType.getName().equals("uima.cas.String")) {
            return ((StringArray)array).get(index);
        }
        if (cType.getName().equals("uima.cas.Double")) {
            return ((DoubleArray)array).get(index);
        }
        if (cType.getName().equals("uima.cas.Integer")) {
            return ((IntegerArray)array).get(index);
        }
        return null;
    }

    private Object apply(FeatureStructure a, String[] path) {
        FeatureStructure current = a;
        for (int i = 0; i < path.length; ++i) {
            if (current == null) {
                return null;
            }
            String featureName = path[i];
            if (featureName.contains("(")) {
                return this.getPrimitiveFunction(current, featureName);
            }
            if (current.getType().isArray()) {
                int arrayIndex = Integer.valueOf(featureName);
                if (current.getType().getComponentType().isPrimitive()) {
                    return this.getPrimitiveComponent(current, arrayIndex);
                }
                FSArray arr = (FSArray)current;
                current = arr.get(arrayIndex);
                continue;
            }
            Feature feature = current.getType().getFeatureByBaseName(featureName);
            if (feature.getRange().isPrimitive()) {
                return this.getPrimitive(current, feature);
            }
            current = current.getFeatureValue(feature);
        }
        return null;
    }
}

