/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import de.unistuttgart.ims.uimautil.export.MyFeaturePathColumn;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeBasedTableExport {
    MissingValueBehaviour missingValueBehaviour = MissingValueBehaviour.FILL;
    Configuration configuration;
    List<Class<? extends TOP>> annotationTypes = new LinkedList<Class<? extends TOP>>();
    TypeSystem typeSystem;
    List<Object> header = new LinkedList<Object>();
    transient boolean headerDone = false;
    transient int tableWidth = -1;

    public TreeBasedTableExport(Configuration config, TypeSystem ts) {
        this.typeSystem = ts;
        this.configuration = config;
    }

    protected void addPathEntry(Class<? extends TOP> type, String paths) {
        this.configuration.addProperty(type.getCanonicalName().replaceAll("\\.", "..") + ".paths", (Object)paths);
    }

    protected void addArrayEntry(Class<? extends TOP> type, String featureNames) {
        this.configuration.addProperty(type.getCanonicalName().replaceAll("\\.", "..") + ".arraymulti", (Object)featureNames);
    }

    protected Tree<FeatureStructure> getFullTree(JCas jcas) {
        Tree<FeatureStructure> tree = this.populateTree(jcas);
        tree = this.extendCoverings(tree);
        tree = this.extendArrays(tree);
        return tree;
    }

    public synchronized List<List<Object>> convert(JCas jcas, boolean newHeader) {
        Tree<FeatureStructure> tree = this.getFullTree(jcas);
        if (newHeader) {
            this.headerDone = false;
            this.header = new LinkedList<Object>();
        }
        LinkedList<List<Object>> table = new LinkedList<List<Object>>();
        this.flatten(new LinkedList<Object>(), tree, table, 0);
        if (newHeader) {
            table.add(0, this.header);
        }
        return table;
    }

    protected List<Object> getColumns(FeatureStructure fs, int treelevel) {
        LinkedList<Object> r = new LinkedList<Object>();
        String[] paths = this.getUnaryFeaturePathsForType(fs.getType());
        String[] labels = this.getColumnHeadersForType(fs.getType());
        for (int i = 0; i < paths.length; ++i) {
            MyFeaturePathColumn pcol = new MyFeaturePathColumn(paths[i]);
            r.add(pcol.getValue(fs));
            if (this.headerDone) continue;
            String l = labels.length > i ? labels[i] : paths[i];
            this.header.add((treelevel > 1 ? this.getHeaderPrefixForType(fs.getType()) + "." : "") + l);
        }
        return r;
    }

    protected String getHeaderPrefixForType(Type type) {
        return this.configuration.getString("typeNameMapping." + type.getName().replaceAll("\\.", ".."), type.getShortName());
    }

    private String[] getColumnHeadersForType(Type type) {
        String confKey = type.getName().replaceAll("\\.", "..") + ".labels";
        String confEntry = this.configuration.getString(confKey, null);
        if (confEntry != null && !confEntry.isEmpty()) {
            return confEntry.split(",");
        }
        return new String[0];
    }

    private String[] getUnaryFeaturePathsForType(Type type) {
        String confKey = type.getName().replaceAll("\\.", "..") + ".paths";
        String confEntry = this.configuration.getString(confKey, null);
        if (confEntry != null && !confEntry.isEmpty()) {
            return confEntry.split(",");
        }
        return new String[0];
    }

    private String[] getCoveringsForType(Type type) {
        String confKey = type.getName().replaceAll("\\.", "..") + ".covered";
        String confEntry = this.configuration.getString(confKey, null);
        if (confEntry != null && !confEntry.isEmpty()) {
            return confEntry.split(",");
        }
        return new String[0];
    }

    private String[] getArrayMultiplierForType(Type type) {
        String confKey = type.getName().replaceAll("\\.", "..") + ".arraymulti";
        String confEntry = this.configuration.getString(confKey, null);
        if (confEntry != null && !confEntry.isEmpty()) {
            return confEntry.split(",");
        }
        return new String[0];
    }

    protected void flatten(List<Object> history, Tree<FeatureStructure> tree, List<List<Object>> table, int treelevel) {
        history.addAll(this.getColumns(tree.getPayload(), treelevel));
        if (tree.isLeaf()) {
            if (history.size() == this.header.size()) {
                table.add(history);
            } else {
                switch (this.missingValueBehaviour) {
                    case OMIT: {
                        break;
                    }
                    default: {
                        do {
                            history.add(null);
                        } while (history.size() < this.header.size());
                        table.add(history);
                    }
                }
            }
            this.headerDone = true;
        } else {
            for (Tree<FeatureStructure> child : tree.getChildren()) {
                this.flatten(new LinkedList<Object>(history), child, table, treelevel + 1);
            }
        }
    }

    protected Tree<FeatureStructure> extendArrays(Tree<FeatureStructure> tree) {
        Type type = tree.getPayload().getType();
        String[] aFeatures = this.getArrayMultiplierForType(type);
        for (String s : aFeatures) {
            Tree<FeatureStructure> nChild;
            Feature feature = type.getFeatureByBaseName(s);
            List children = tree.getChildren();
            FSArray arr = (FSArray)tree.getPayload().getFeatureValue(feature);
            Type cType = feature.getRange().getComponentType();
            if (arr == null || arr.size() == 0) {
                tree.setChildren(new ArrayList());
                FeatureStructure fs = tree.getPayload().getCAS().createFS(cType);
                tree.getPayload().getCAS().addFsToIndexes(fs);
                nChild = new Tree<FeatureStructure>(fs);
                nChild.setChildren(children);
                tree.add((FeatureStructure)nChild);
                continue;
            }
            tree.setChildren(new ArrayList(arr.size()));
            for (int i = 0; i < arr.size(); ++i) {
                nChild = new Tree<FeatureStructure>(arr.get(i));
                nChild.setChildren(children);
                tree.add((FeatureStructure)nChild);
            }
        }
        for (Tree tree2 : tree.getChildren()) {
            this.extendArrays(tree2);
        }
        return tree;
    }

    protected Tree<FeatureStructure> extendCoverings(Tree<FeatureStructure> tree) {
        Type type = tree.getPayload().getType();
        String[] coverings = this.getCoveringsForType(type);
        for (String covType : coverings) {
            try {
                Class<?> annoClass = Class.forName(covType);
                List children = tree.getChildren();
                List annos = JCasUtil.selectCovered(annoClass, (AnnotationFS)((Annotation)tree.getPayload()));
                tree.setChildren(new ArrayList(annos.size()));
                for (Annotation a : annos) {
                    Tree<Annotation> nChild = new Tree<Annotation>(a);
                    nChild.setChildren(children);
                    tree.add((FeatureStructure)nChild);
                }
                if (!annos.isEmpty()) continue;
                FeatureStructure fs = tree.getPayload().getCAS().createFS(this.typeSystem.getType(covType));
                tree.getPayload().getCAS().addFsToIndexes(fs);
                Tree<FeatureStructure> nChild = new Tree<FeatureStructure>(fs);
                nChild.setChildren(children);
                tree.add((FeatureStructure)nChild);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        for (Tree tree2 : tree.getChildren()) {
            this.extendCoverings(tree2);
        }
        return tree;
    }

    protected Tree<FeatureStructure> populateTree(JCas jcas) {
        Tree<TOP> tree = new Tree<TOP>(jcas.getDocumentAnnotationFs());
        for (TOP a : JCasUtil.select((JCas)jcas, this.annotationTypes.get(0))) {
            tree.add((TOP)this.populateTree(jcas, a, 1));
        }
        return tree;
    }

    protected Tree<FeatureStructure> populateTree(JCas jcas, TOP anno, int typeIndex) {
        Tree<TOP> tree;
        block4: {
            tree = new Tree<TOP>(anno);
            if (this.annotationTypes.size() <= typeIndex) break block4;
            if (anno instanceof Annotation) {
                Class<? extends TOP> rAnno = this.annotationTypes.get(typeIndex);
                for (TOP a : JCasUtil.selectCovered(rAnno, (AnnotationFS)((Annotation)anno))) {
                    tree.add((TOP)this.populateTree(jcas, a, typeIndex + 1));
                }
            } else {
                for (TOP a : JCasUtil.select((JCas)jcas, this.annotationTypes.get(typeIndex))) {
                    tree.add((TOP)this.populateTree(jcas, a, typeIndex + 1));
                }
            }
        }
        return tree;
    }

    public List<Class<? extends TOP>> getTypesToExport() {
        return this.annotationTypes;
    }

    public void setAnnotationTypes(List<Class<? extends TOP>> typesToExport) {
        this.annotationTypes = typesToExport;
    }

    public boolean addAnnotationType(Class<? extends TOP> type) {
        return this.annotationTypes.add(type);
    }

    public MissingValueBehaviour getMissingValueBehaviour() {
        return this.missingValueBehaviour;
    }

    public void setMissingValueBehaviour(MissingValueBehaviour missingValueBehaviour) {
        this.missingValueBehaviour = missingValueBehaviour;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Tree<T> {
        T payload;
        List<Tree<T>> children = new ArrayList<Tree<T>>();

        public Tree(T col) {
            this.payload = col;
        }

        public T getPayload() {
            return this.payload;
        }

        public void setPayload(T column) {
            this.payload = column;
        }

        public Tree<T> getChild(int i) {
            return this.getChildren().get(i);
        }

        public List<Tree<T>> getChildren() {
            return this.children;
        }

        public void setChildren(List<Tree<T>> children) {
            this.children = children;
        }

        public boolean add(Tree<T> e) {
            return this.children.add(e);
        }

        public boolean add(T e) {
            return this.children.add(new Tree<T>(e));
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public String toString() {
            return this.toString(0);
        }

        public String toString(int indent) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < indent; ++i) {
                b.append(" ");
            }
            b.append(StringEscapeUtils.ESCAPE_JAVA.translate((CharSequence)this.payload.toString())).append("\n");
            for (Tree<T> child : this.children) {
                b.append(child.toString(indent + 3));
            }
            return b.toString();
        }

        public int height() {
            if (this.children.isEmpty()) {
                return 1;
            }
            return this.children.get(0).height() + 1;
        }

        public int size() {
            return this.children.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MissingValueBehaviour {
        FILL,
        OMIT;

    }
}

