/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData;
import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Token;
import de.unistuttgart.ims.uimautil.export.Column;
import de.unistuttgart.ims.uimautil.export.CoveredColumn;
import de.unistuttgart.ims.uimautil.export.FeaturePathColumn;
import de.unistuttgart.ims.uimautil.export.PrimitiveColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.uima.UIMAException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CoNLLExport {
    Configuration configuration;
    List<Column> columnList;
    Type type;
    Class<? extends TOP> annotationClass;
    Class<? extends Annotation> coveredAnnotationClass;
    List<List<Object>> result = new LinkedList<List<Object>>();

    public List<List<Object>> getResult() {
        return this.result;
    }

    public List<? extends List<Object>> convert(JCas jcas) {
        Collection annotationList = JCasUtil.select((JCas)jcas, this.annotationClass);
        for (TOP a : annotationList) {
            this.result.addAll(this.printFeatureValues(a, this.columnList.iterator()));
        }
        return this.result;
    }

    public void init(Configuration config, JCas jcas, Class<? extends TOP> annotationClass, Class<? extends Annotation> coveredAnnotationClass) throws UIMAException {
        this.configuration = config;
        this.annotationClass = annotationClass;
        this.coveredAnnotationClass = coveredAnnotationClass;
        this.result = new LinkedList<List<Object>>();
        jcas = JCasFactory.createJCas();
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription();
        TypeDescription td = tsd.getType(annotationClass.getName());
        this.type = jcas.getTypeSystem().getType(td.getName());
        Type coveredType = null;
        if (coveredAnnotationClass != null) {
            coveredType = jcas.getTypeSystem().getType(coveredAnnotationClass.getName());
        }
        this.columnList = this.getColumns(jcas, this.type, coveredType);
        String confKey = this.type.getName().replaceAll("\\.", "..") + ".fixed";
        String[] confValues = this.configuration.getString(confKey, "").split(",");
        String[] confValueLabels = this.configuration.getString(confKey + "_labels", "").split(",");
        for (int i = 0; i < confValues.length; ++i) {
            String confEntry = confValues[i].trim();
            String confEntryLabel = confValueLabels[i].trim();
            if (confEntry.equalsIgnoreCase("DocumentId")) {
                this.columnList.add(0, new Column(new String[]{confEntryLabel}){

                    public Object getValue(TOP a) {
                        try {
                            return DocumentMetaData.get((CAS)a.getCAS()).getDocumentId();
                        }
                        catch (Exception e) {
                            return "";
                        }
                    }

                    public boolean isMultiplying() {
                        return false;
                    }
                });
                continue;
            }
            if (confEntry.equalsIgnoreCase("CollectionId")) {
                this.columnList.add(0, new Column(new String[]{confEntryLabel}){

                    public Object getValue(TOP a) {
                        try {
                            return DocumentMetaData.get((CAS)a.getCAS()).getCollectionId();
                        }
                        catch (Exception e) {
                            return "";
                        }
                    }

                    public boolean isMultiplying() {
                        return false;
                    }
                });
                continue;
            }
            if (!confEntry.equalsIgnoreCase("Length")) continue;
            this.columnList.add(0, new Column(new String[]{confEntryLabel}){

                public Object getValue(TOP a) {
                    try {
                        JCas jcas = a.getCAS().getJCas();
                        return JCasUtil.select((JCas)jcas, Token.class).size();
                    }
                    catch (CASException e) {
                        e.printStackTrace();
                        return 0;
                    }
                }

                public boolean isMultiplying() {
                    return false;
                }
            });
        }
        LinkedList<String> header = new LinkedList<String>();
        for (Column ee : this.columnList) {
            for (String s : ee.getLabel()) {
                header.add(s);
            }
        }
        this.result.add(header);
    }

    private ArrayList<ArrayList<Object>> printFeatureValues(TOP a, Iterator<Column> eelist) {
        ArrayList<ArrayList<Object>> r = new ArrayList<ArrayList<Object>>();
        r.add(new ArrayList());
        while (eelist.hasNext()) {
            Column ee = eelist.next();
            Object value = ee.getValue(a);
            if (ee.isMultiplying()) {
                int j;
                ArrayList<ArrayList<ArrayList<Object>>> clones = new ArrayList<ArrayList<ArrayList<Object>>>();
                Object[] objectArray = (Object[])value;
                for (j = 1; j < objectArray.length; ++j) {
                    clones.add(this.deepClone(r));
                }
                for (List list : r) {
                    if (objectArray.length == 0) {
                        list.add("");
                        continue;
                    }
                    for (Object o : (Object[])objectArray[0]) {
                        list.add(o);
                    }
                }
                for (j = 1; j < objectArray.length; ++j) {
                    for (ArrayList l : (ArrayList)clones.get(j - 1)) {
                        for (Object o : (Object[])objectArray[j]) {
                            l.add(o);
                        }
                    }
                    r.addAll((Collection)clones.get(j - 1));
                }
                continue;
            }
            for (List list : r) {
                list.add(value);
            }
        }
        return r;
    }

    private String[] getFeaturePathsForType(Type type) {
        String confKey = type.getName().replaceAll("\\.", "..") + ".paths";
        String confEntry = this.configuration.getString(confKey, null);
        if (confEntry != null && !confEntry.isEmpty()) {
            return confEntry.split(",");
        }
        return new String[0];
    }

    private String[] getColumnHeadersForType(Type type) {
        String confKey = type.getName().replaceAll("\\.", "..") + ".labels";
        String confEntry = this.configuration.getString(confKey, null);
        if (confEntry != null && !confEntry.isEmpty()) {
            return confEntry.split(",");
        }
        return new String[0];
    }

    private ArrayList<ArrayList<Object>> deepClone(ArrayList<ArrayList<Object>> list) {
        ArrayList<ArrayList<Object>> ret = new ArrayList<ArrayList<Object>>();
        for (ArrayList<Object> l : list) {
            ret.add((ArrayList)l.clone());
        }
        return ret;
    }

    private List<Column> getColumns(JCas jcas, Type type, Type coveredType) {
        LinkedList<Column> eelist = new LinkedList<Column>();
        for (Feature fd : type.getFeatures()) {
            if (!fd.getRange().isPrimitive()) continue;
            PrimitiveColumn pee = new PrimitiveColumn(jcas.getTypeSystem().getFeatureByFullName(fd.getName()));
            eelist.add(pee);
        }
        String[] paths = this.getFeaturePathsForType(type);
        String[] labels = this.getColumnHeadersForType(type);
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            FeaturePath fp = jcas.createFeaturePath();
            try {
                fp.initialize(path);
                fp.typeInit(type);
                if (labels.length > i) {
                    eelist.add(new FeaturePathColumn(fp, labels[i]));
                    continue;
                }
                eelist.add(new FeaturePathColumn(fp));
                continue;
            }
            catch (CASException e) {
                e.printStackTrace();
            }
        }
        String[] covTypes = this.getCoveringsForType(type);
        for (int j = 0; j < covTypes.length; ++j) {
            paths = this.getFeaturePathsForType(jcas.getTypeSystem().getType(covTypes[j]));
            labels = this.getColumnHeadersForType(jcas.getTypeSystem().getType(covTypes[j]));
            FeaturePath[] path = new FeaturePath[paths.length];
            for (int i = 0; i < path.length; ++i) {
                path[i] = jcas.createFeaturePath();
                try {
                    labels[i] = Class.forName(covTypes[j]).getSimpleName() + "/" + labels[i];
                }
                catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                }
                try {
                    path[i].initialize(paths[i]);
                    path[i].typeInit(jcas.getTypeSystem().getType(covTypes[j]));
                    continue;
                }
                catch (CASException e) {
                    e.printStackTrace();
                }
            }
            try {
                CoveredColumn ee = new CoveredColumn(Class.forName(covTypes[j]), path);
                ee.setLabel(labels);
                eelist.add(ee);
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (coveredType != null) {
            labels = this.getColumnHeadersForType(coveredType);
            paths = this.getFeaturePathsForType(coveredType);
            FeaturePath[] path = new FeaturePath[paths.length];
            for (int i = 0; i < path.length; ++i) {
                path[i] = jcas.createFeaturePath();
                try {
                    labels[i] = coveredType.getShortName() + "/" + labels[i];
                    path[i].initialize(paths[i]);
                    path[i].typeInit(coveredType);
                    continue;
                }
                catch (CASException e) {
                    e.printStackTrace();
                }
            }
            try {
                CoveredColumn ee = new CoveredColumn(Class.forName(coveredType.getName()), path);
                ee.setLabel(labels);
                eelist.add(ee);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return eelist;
    }

    private String[] getCoveringsForType(Type type) {
        String confKey = type.getName().replaceAll("\\.", "..") + ".covered";
        String confEntry = this.configuration.getString(confKey, null);
        if (confEntry != null && !confEntry.isEmpty()) {
            return confEntry.split(",");
        }
        return new String[0];
    }

    public void clearResult() {
        this.result.clear();
    }
}

