/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import de.unistuttgart.ims.uimautil.CoNLLExport;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.OverrideCombiner;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.uima.UIMAException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.component.JCasConsumer_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@OperationalProperties(multipleDeploymentAllowed=false)
public class CoNLLCasConsumer
extends JCasConsumer_ImplBase {
    public static final String PARAM_OUTPUT_FILE = "Output File";
    public static final String PARAM_CONFIGURATION_FILE = "Configuration URL";
    public static final String PARAM_ANNOTATION_CLASS = "Annotation Class";
    public static final String PARAM_FEATURE_PATHS = "Feature Paths";
    public static final String PARAM_COLUMN_LABELS = "Feature Path Labels";
    public static final String PARAM_COVERED_ANNOTATION_CLASS = "Covered Annotation Class";
    @ConfigurationParameter(name="Output File", mandatory=true)
    File outputFile;
    @ConfigurationParameter(name="Annotation Class", defaultValue={"de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Token"})
    String annotationClassName;
    @ConfigurationParameter(name="Configuration URL")
    String configurationFile;
    @ConfigurationParameter(name="Covered Annotation Class", mandatory=false)
    String coveredAnnotationClassName = null;
    CSVPrinter csvPrinter;
    CombinedConfiguration config;
    Type type;
    CoNLLExport exporter;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        JCas jcas;
        super.initialize(context);
        INIConfiguration defaultConfig = new INIConfiguration();
        INIConfiguration serverConfig = new INIConfiguration();
        InputStream is = null;
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream("/project.properties");
            if (is != null) {
                defaultConfig.read((Reader)new InputStreamReader(is, "UTF-8"));
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new ResourceInitializationException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)is);
        try {
            URL url = new URL(this.configurationFile);
            is = url.openStream();
            serverConfig.read((Reader)new InputStreamReader(is, "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceInitializationException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)is);
        }
        this.config = new CombinedConfiguration((NodeCombiner)new OverrideCombiner());
        this.config.addConfiguration((Configuration)serverConfig);
        this.config.addConfiguration((Configuration)defaultConfig);
        Class<?> annotationClass = null;
        Class<?> coveredAnnotationClass = null;
        Class<?> cl = null;
        try {
            cl = Class.forName(this.annotationClassName);
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
            throw new ResourceInitializationException((Throwable)e2);
        }
        if (cl != null) {
            annotationClass = cl;
        }
        cl = null;
        if (this.coveredAnnotationClassName != null) {
            try {
                cl = Class.forName(this.coveredAnnotationClassName);
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
                throw new ResourceInitializationException((Throwable)e2);
            }
        }
        if (cl != null) {
            coveredAnnotationClass = cl;
        }
        try {
            jcas = JCasFactory.createJCas();
        }
        catch (UIMAException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.exporter = new CoNLLExport();
        try {
            this.exporter.init((Configuration)this.config, jcas, annotationClass, coveredAnnotationClass);
        }
        catch (UIMAException e) {
            e.printStackTrace();
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        this.exporter.convert(jcas);
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        try {
            this.csvPrinter = new CSVPrinter((Appendable)new FileWriter(this.outputFile), CSVFormat.DEFAULT);
            for (List<Object> row : this.exporter.getResult()) {
                this.csvPrinter.printRecord(row);
            }
            this.csvPrinter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        IOUtils.closeQuietly((Closeable)this.csvPrinter);
    }
}

