/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil.export;

import de.unistuttgart.ims.uimautil.export.Column;
import de.unistuttgart.ims.uimautil.export.Datatype;
import org.apache.uima.cas.Feature;
import org.apache.uima.jcas.cas.TOP;

public class PrimitiveColumn
extends Column {
    Feature feature;

    public PrimitiveColumn(Feature feature) {
        super(new String[]{feature.getShortName()});
        this.datatype = Datatype.fromString(feature.getRange().getName());
        this.feature = feature;
    }

    public Object getValue(TOP a) {
        switch (this.getDatatype()) {
            case BOOLEAN: {
                return a.getBooleanValue(this.feature);
            }
            case DOUBLE: {
                return a.getDoubleValue(this.feature);
            }
            case FLOAT: {
                return Float.valueOf(a.getFloatValue(this.feature));
            }
            case INTEGER: {
                return a.getIntValue(this.feature);
            }
            case STRING: {
                return a.getFeatureValueAsString(this.feature);
            }
            case LONG: {
                return a.getLongValue(this.feature);
            }
        }
        return null;
    }

    public boolean isMultiplying() {
        return false;
    }
}

