/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import de.unistuttgart.ims.uimautil.AbstractWindowAnnotator;
import de.unistuttgart.ims.uimautil.TypeParameterUtil;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowAnnotator
extends AbstractWindowAnnotator {
    public static final String PARAM_WINDOW_SIZE = "Window Size";
    public static final String PARAM_OVERLAPS = "Overlapping Windows";
    public static final String PARAM_SEGMENT_ANNOTATION = "Segment Annotation";
    @ConfigurationParameter(name="Segment Annotation", mandatory=false, defaultValue={"null"})
    String segmentAnnotationClassName = null;
    @ConfigurationParameter(name="Window Size", mandatory=true)
    int windowSize;
    @ConfigurationParameter(name="Overlapping Windows", mandatory=false, defaultValue={"false"})
    boolean overlappingWindows = false;
    Class<? extends Annotation> segmentAnnotationClass = null;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.segmentAnnotationClass = TypeParameterUtil.getClass(this.segmentAnnotationClassName, null);
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        if (this.segmentAnnotationClass != null) {
            for (Annotation segAnno : JCasUtil.select((JCas)jcas, this.segmentAnnotationClass)) {
                this.doAnnotations(jcas, JCasUtil.selectCovered((JCas)jcas, (Class)this.baseAnnotation, (AnnotationFS)segAnno), segAnno.getEnd());
            }
        } else {
            this.doAnnotations(jcas, JCasUtil.select((JCas)jcas, (Class)this.baseAnnotation), jcas.getDocumentText().length());
        }
    }

    protected void doAnnotations(JCas jcas, Collection<? extends Annotation> baseAnnotations, int end) {
        int i = 0;
        int b = 0;
        LinkedList<Annotation> window = null;
        if (this.overlappingWindows) {
            window = new LinkedList<Annotation>();
        }
        for (Annotation annotation : baseAnnotations) {
            if (this.overlappingWindows) {
                window.add(annotation);
                if (window.size() < this.windowSize) continue;
                Annotation firstAnno = (Annotation)window.pop();
                AnnotationFactory.createAnnotation((JCas)jcas, (int)firstAnno.getBegin(), (int)annotation.getEnd(), (Class)this.targetAnnotation);
                continue;
            }
            if (++i % this.windowSize == 0) {
                AnnotationFactory.createAnnotation((JCas)jcas, (int)b, (int)annotation.getEnd(), (Class)this.targetAnnotation);
            }
            if (i % this.windowSize != 1) continue;
            b = annotation.getBegin();
        }
        if (!this.overlappingWindows) {
            AnnotationFactory.createAnnotation((JCas)jcas, (int)b, (int)end, (Class)this.targetAnnotation);
        }
    }
}

