/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import de.unistuttgart.ims.uimautil.AbstractWindowAnnotator;
import java.util.LinkedList;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class FixedNumberWindowAnnotator
extends AbstractWindowAnnotator {
    public static final String PARAM_NUMBER_WINDOWS = "Number of Windows";
    @ConfigurationParameter(name="Number of Windows", defaultValue={"10"}, mandatory=false)
    int numberOfWindows = 10;

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        LinkedList bases = new LinkedList(JCasUtil.select((JCas)jcas, (Class)this.baseAnnotation));
        int n = bases.size();
        double avgLength = (double)n / (double)this.numberOfWindows;
        int c = (int)Math.ceil(avgLength);
        int last = -1;
        int windows = 0;
        for (int i = 0; i < n; ++i) {
            if (i % c != 0 || windows >= this.numberOfWindows - 1 || last + 1 == i) continue;
            AnnotationFactory.createAnnotation((JCas)jcas, (int)((Annotation)bases.get(last + 1)).getBegin(), (int)((Annotation)bases.get(i)).getEnd(), (Class)this.targetAnnotation);
            ++windows;
            last = i;
        }
        AnnotationFactory.createAnnotation((JCas)jcas, (int)((Annotation)bases.get(last)).getBegin(), (int)((Annotation)bases.getLast()).getEnd(), (Class)this.targetAnnotation);
    }
}

