/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import de.tudarmstadt.ukp.dkpro.core.api.io.JCasFileWriter_ImplBase;
import de.unistuttgart.ims.uimautil.TypeParameterUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;

public class DocumentCSVConsumer
extends JCasFileWriter_ImplBase {
    public static final String PARAM_ANNOTATION_TYPE = "Annotation Type";
    public static final String PARAM_DATASET_NAME = "Dataset Name";
    public static final String PARAM_FIRST_FEATURE = "First Feature";
    public static final String PARAM_LAST_FEATURE = "Last Feature";
    @ConfigurationParameter(name="Annotation Type", mandatory=true)
    String annotationType = null;
    @ConfigurationParameter(name="Dataset Name", mandatory=false, defaultValue={"Data Set"})
    String datasetName = "Data Set";
    @ConfigurationParameter(name="Last Feature", mandatory=false)
    String lastFeatureName;
    @ConfigurationParameter(name="First Feature", mandatory=false)
    String firstFeatureName;
    TypeDescription typeDescription;
    Map<String, Integer> attributeMap;
    List<String> attributes;
    int numAttributes = 0;
    Class<? extends Annotation> cl;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.attributeMap = new HashMap<String, Integer>();
        this.attributes = new LinkedList<String>();
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription();
        this.typeDescription = tsd.getType(this.annotationType);
        String lastAttribute = null;
        String firstAttribute = null;
        if (this.typeDescription == null) {
            throw new ResourceInitializationException("could_not_instantiate", (Object[])new String[]{this.annotationType});
        }
        FeatureDescription[] fds = this.typeDescription.getFeatures();
        int f = 0;
        for (int i = 0; i < fds.length; ++i) {
            String attr = null;
            FeatureDescription fd = fds[i];
            if (fd.getName().equals(this.lastFeatureName)) {
                lastAttribute = this.makeAttribute(fd);
            } else if (fd.getName().equals(this.firstFeatureName)) {
                firstAttribute = this.makeAttribute(fd);
            } else {
                attr = this.makeAttribute(fd);
            }
            if (attr == null) continue;
            this.attributes.add(attr);
            this.attributeMap.put(fd.getName(), f++);
        }
        if (lastAttribute != null) {
            this.attributes.add(lastAttribute);
            this.attributeMap.put(this.lastFeatureName, f);
        }
        if (firstAttribute != null) {
            this.attributes.add(0, firstAttribute);
        }
        this.cl = TypeParameterUtil.getClass(this.annotationType);
    }

    protected String makeAttribute(FeatureDescription fd) {
        String rangeTypeName = fd.getRangeTypeName();
        Attribute attr = null;
        if (rangeTypeName.equals("uima.cas.String")) {
            attr = new Attribute(fd.getName());
            return fd.getName();
        }
        if (rangeTypeName.equals("uima.cas.Integer")) {
            attr = new Attribute(fd.getName());
            return fd.getName();
        }
        if (rangeTypeName.equals("uima.cas.Double")) {
            attr = new Attribute(fd.getName());
            return fd.getName();
        }
        if (rangeTypeName.equals("uima.cas.Boolean")) {
            attr = new Attribute(fd.getName());
            return fd.getName();
        }
        return null;
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        JCasFileWriter_ImplBase.NamedOutputStream aw = null;
        PrintStream ps = null;
        CSVPrinter p = null;
        try {
            aw = this.getOutputStream(jcas, ".csv");
            ps = new PrintStream((OutputStream)aw);
            p = new CSVPrinter((Appendable)ps, CSVFormat.DEFAULT);
            Type type = jcas.getTypeSystem().getType(this.typeDescription.getName());
            for (Annotation anno : JCasUtil.select((JCas)jcas, this.cl)) {
                for (String attr : this.attributes) {
                    Feature feature = anno.getType().getFeatureByBaseName(attr);
                    if (!feature.getDomain().equals(type)) continue;
                    if (feature.getRange().getName().equals("uima.cas.String")) {
                        if (anno == null || anno.getFeatureValueAsString(feature) == null) {
                            p.print(null);
                            continue;
                        }
                        p.print((Object)anno.getFeatureValueAsString(feature));
                        continue;
                    }
                    if (feature.getRange().getName().equals("uima.cas.Integer")) {
                        p.print((Object)anno.getIntValue(feature));
                        continue;
                    }
                    if (feature.getRange().getName().equals("uima.cas.Double")) {
                        p.print((Object)anno.getDoubleValue(feature));
                        continue;
                    }
                    if (!feature.getRange().getName().equals("uima.cas.Boolean")) continue;
                    p.print((Object)anno.getBooleanValue(feature));
                }
                p.println();
            }
            p.flush();
            ps.flush();
            aw.flush();
            p.close();
            ps.close();
            aw.close();
        }
        catch (IOException e) {
            try {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ps);
                IOUtils.closeQuietly((OutputStream)aw);
                IOUtils.closeQuietly(p);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)ps);
        IOUtils.closeQuietly((OutputStream)aw);
        IOUtils.closeQuietly((Closeable)p);
    }

    public static class Attribute {
        String name;

        public Attribute(String s) {
            this.name = s;
        }

        public Attribute(String s, Object o) {
            this.name = s;
        }
    }
}

