/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import de.unistuttgart.ims.uimautil.TypeParameterUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class CopyAnnotations
extends JCasAnnotator_ImplBase {
    public static final String PARAM_SOURCE_VIEW = "Source View";
    public static final String PARAM_TARGET_VIEW = "Target View";
    public static final String PARAM_ANNOTATION_TYPE = "Annotation Type";
    @ConfigurationParameter(name="Source View")
    String sourceViewName;
    @ConfigurationParameter(name="Target View")
    String targetViewName;
    @ConfigurationParameter(name="Annotation Type")
    String annotationTypeName;
    Class<? extends Annotation> clazz;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.clazz = TypeParameterUtil.getClass(this.annotationTypeName);
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        try {
            JCas srcView = aJCas.getView(this.sourceViewName);
            JCas tgtView = aJCas.getView(this.targetViewName);
            for (Annotation a : JCasUtil.select((JCas)srcView, this.clazz)) {
                AnnotationFactory.createAnnotation((JCas)tgtView, (int)a.getBegin(), (int)a.getEnd(), this.clazz);
            }
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

