/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil.export;

import de.unistuttgart.ims.uimautil.export.ExportEntry;
import de.unistuttgart.ims.uimautil.export.FeaturePathExportEntry;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.tcas.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoveredExportEntry
extends ExportEntry {
    Class<? extends Annotation> coveredClass;
    List<FeaturePathExportEntry> featurePathExportEntries;
    int useCovered = 1;

    public CoveredExportEntry(Class<? extends Annotation> clazz, FeaturePath ... fps) {
        super(new String[fps.length]);
        this.coveredClass = clazz;
        this.featurePathExportEntries = new LinkedList<FeaturePathExportEntry>();
        for (int i = 0; i < fps.length; ++i) {
            this.label[i] = clazz.getSimpleName() + fps[i].getFeaturePath();
            this.featurePathExportEntries.add(new FeaturePathExportEntry(fps[i]));
        }
    }

    @Override
    public Object getValue(Annotation a) {
        List l = JCasUtil.selectCovered(this.coveredClass, (AnnotationFS)a);
        Object[][] r = new Object[l.size()][this.featurePathExportEntries.size()];
        if (l.isEmpty()) {
            r = new Object[1][this.featurePathExportEntries.size()];
            for (int j = 0; j < this.featurePathExportEntries.size(); ++j) {
                r[0][j] = "";
            }
        } else {
            for (int i = 0; i < r.length; ++i) {
                for (int j = 0; j < this.featurePathExportEntries.size(); ++j) {
                    try {
                        r[i][j] = this.featurePathExportEntries.get(j).getValue((Annotation)l.get(i));
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        r[i][j] = "";
                    }
                }
            }
        }
        return r;
    }

    @Override
    public boolean isMultiplying() {
        return true;
    }
}

