/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class WordTagger
extends JCasAnnotator_ImplBase {
    public static final String PARAM_WORD = "Word";
    public static final String PARAM_BASE_ANNOTATION = "Base Annotation";
    public static final String PARAM_TARGET_ANNOTATION = "Target Annotation";
    public static final String PARAM_CI = "Casing";
    @ConfigurationParameter(name="Word", mandatory=true)
    String word;
    @ConfigurationParameter(name="Base Annotation", mandatory=false)
    String baseAnnotationClassName = null;
    @ConfigurationParameter(name="Target Annotation", mandatory=true)
    String targetAnnotationClassName = null;
    @ConfigurationParameter(name="Casing", mandatory=false, defaultValue={"false"})
    boolean caseIndependent = false;
    Class<? extends Annotation> targetAnnotation = null;
    Class<? extends Annotation> baseAnnotation = null;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        block6: {
            Class<?> tA;
            super.initialize(context);
            try {
                tA = Class.forName(this.targetAnnotationClassName);
                if (!Annotation.class.isAssignableFrom(tA)) {
                    throw new ResourceInitializationException();
                }
                this.targetAnnotation = tA;
            }
            catch (ClassNotFoundException e1) {
                throw new ResourceInitializationException((Throwable)e1);
            }
            try {
                if (this.baseAnnotationClassName == null) break block6;
                tA = Class.forName(this.baseAnnotationClassName);
                if (Annotation.class.isAssignableFrom(tA)) {
                    this.baseAnnotation = tA;
                    break block6;
                }
                throw new ResourceInitializationException();
            }
            catch (ClassNotFoundException e1) {
                throw new ResourceInitializationException((Throwable)e1);
            }
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        if (this.baseAnnotation != null) {
            for (Annotation anno : JCasUtil.select((JCas)jcas, this.baseAnnotation)) {
                if ((!this.caseIndependent || !anno.getCoveredText().equalsIgnoreCase(this.word)) && !anno.getCoveredText().equals(this.word)) continue;
                AnnotationFactory.createAnnotation((JCas)jcas, (int)anno.getBegin(), (int)anno.getEnd(), this.targetAnnotation);
            }
        } else {
            Pattern pattern = Pattern.compile(this.word, 0x40 | (this.caseIndependent ? 2 : 0));
            Matcher matcher = pattern.matcher(jcas.getDocumentText());
            while (matcher.find()) {
                AnnotationFactory.createAnnotation((JCas)jcas, (int)matcher.start(), (int)matcher.end(), this.targetAnnotation);
            }
        }
    }
}

