/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Lemma;
import de.unistuttgart.ims.uimautil.SimpleTagger;
import de.unistuttgart.ims.uimautil.WordListDescription;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.Resource_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;

public class NGramTagger
extends SimpleTagger {
    public static final String RESOURCE_WORDLIST = "N-Gram List";
    @ExternalResource(key="N-Gram List", mandatory=true)
    NGramList wordList;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        long startTimestamp = System.currentTimeMillis();
        WordListDescription desc = (WordListDescription)AnnotationFactory.createAnnotation((JCas)jcas, (int)0, (int)0, WordListDescription.class);
        desc.setLength(this.wordList.getLength(this.caseIndependent));
        desc.setName(this.wordList.listName);
        Feature feature = null;
        if (this.targetFeatureName != null) {
            feature = jcas.getTypeSystem().getType(this.targetAnnotationClassName).getFeatureByBaseName(this.targetFeatureName);
        }
        HashMap lemmaIndex = new HashMap();
        for (Lemma lemma : JCasUtil.select((JCas)jcas, Lemma.class)) {
            String indexEntry = lemma.getValue().toLowerCase();
            if (!lemmaIndex.containsKey(indexEntry)) {
                lemmaIndex.put(indexEntry, new LinkedList());
            }
            ((List)lemmaIndex.get(indexEntry)).add(lemma);
        }
        for (String[] stringArray : this.wordList.getEntries()) {
            if (!lemmaIndex.containsKey(stringArray[0].toLowerCase())) continue;
            for (Lemma lemma : (List)lemmaIndex.get(stringArray[0].toLowerCase())) {
                int begin = lemma.getBegin();
                int end = lemma.getEnd();
                for (int i = 1; i < stringArray.length; ++i) {
                    Lemma nextLemma = (Lemma)JCasUtil.selectFollowing(Lemma.class, (AnnotationFS)lemma, (int)1).get(0);
                    end = nextLemma.getValue().equalsIgnoreCase(stringArray[i].toLowerCase()) ? nextLemma.getEnd() : -1;
                }
                if (end < 0) continue;
                Annotation newAnno = AnnotationFactory.createAnnotation((JCas)jcas, (int)begin, (int)end, (Class)this.targetAnnotation);
                if (feature == null) continue;
                newAnno.setFeatureValueFromString(feature, this.wordList.listName);
            }
        }
        HashSet toRemove = new HashSet();
        for (Annotation a : JCasUtil.select((JCas)jcas, (Class)this.targetAnnotation)) {
            toRemove.addAll(JCasUtil.selectCovered((Class)this.targetAnnotation, (AnnotationFS)a));
        }
        for (Annotation a : toRemove) {
            a.removeFromIndexes();
        }
        long l = System.currentTimeMillis() - startTimestamp;
        this.getLogger().info((Object)("NGramTagger took " + l + "ms."));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NGramList
    extends Resource_ImplBase {
        public static final String PARAM_SOURCE_URL = "NGram List URL";
        public static final String PARAM_LIST_NAME = "NGram List Name";
        @ConfigurationParameter(name="NGram List URL", mandatory=true)
        String resourceURL = null;
        @ConfigurationParameter(name="NGram List Name", mandatory=false)
        String listName = null;
        List<String[]> entries = new LinkedList<String[]>();
        int lines = 0;

        public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
            super.initialize(aSpecifier, aAdditionalParams);
            try {
                this.loadFromStream(new URL(this.resourceURL).openStream());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            if (this.listName == null) {
                this.listName = this.resourceURL;
            }
            return true;
        }

        public List<String[]> getEntries() {
            return this.entries;
        }

        public void loadFromStream(InputStream is) throws IOException {
            for (String line : IOUtils.readLines((InputStream)is, (String)"UTF-8")) {
                this.entries.add(line.split("[ \t]"));
                ++this.lines;
            }
        }

        public void afterResourcesInitialized() throws ResourceInitializationException {
        }

        public int getLength(boolean ci) {
            return this.lines;
        }
    }
}

