/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import de.tudarmstadt.ukp.dkpro.core.api.io.JCasFileWriter_ImplBase;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.TreeSet;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class MarkdownExporter
extends JCasFileWriter_ImplBase {
    public static final String PARAM_TYPE = "Type to Export";
    public static final String PARAM_FEATURE = "Feature to subscript";
    public static final String PARAM_BEGIN_MARK = "Begin Mark";
    public static final String PARAM_END_MARK = "End Mark";
    public static final String PARAM_DOUBLE_NEWLINE = "Double Newline";
    @ConfigurationParameter(name="Type to Export")
    String type = null;
    Class<? extends Annotation> clazz;
    @ConfigurationParameter(name="Feature to subscript")
    String featureName = null;
    @ConfigurationParameter(name="Begin Mark", mandatory=false, defaultValue={"["})
    String beginMark = "[";
    @ConfigurationParameter(name="End Mark", mandatory=false, defaultValue={"]"})
    String endMark = "]";
    @ConfigurationParameter(name="Double Newline", mandatory=false, defaultValue={"false"})
    boolean doubleNewline = false;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        Class<?> cl;
        super.initialize(context);
        try {
            cl = Class.forName(this.type);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.clazz = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        block5: {
            JCasFileWriter_ImplBase.NamedOutputStream aw = null;
            PrintStream ps = null;
            try {
                aw = this.getOutputStream(jcas, ".md");
                ps = new PrintStream((OutputStream)aw);
                ps.print(this.getMarkdownString(jcas));
                ps.flush();
                aw.flush();
                IOUtils.closeQuietly((Closeable)ps);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                IOUtils.closeQuietly(ps);
                IOUtils.closeQuietly((Closeable)aw);
            }
            IOUtils.closeQuietly((Closeable)aw);
        }
    }

    public String getMarkdownString(JCas jcas) {
        Feature feat = jcas.getTypeSystem().getType(this.type).getFeatureByBaseName(this.featureName);
        TreeSet<Insertion> insertions = new TreeSet<Insertion>();
        for (Annotation a : JCasUtil.select((JCas)jcas, this.clazz)) {
            insertions.add(new Insertion(this.beginMark, a.getBegin()));
            insertions.add(new Insertion(this.endMark + "~" + a.getFeatureValueAsString(feat) + "~", a.getEnd()));
        }
        StringBuilder exportString = new StringBuilder(jcas.getDocumentText());
        for (Insertion ins : insertions) {
            exportString.insert(ins.position, ins.content);
        }
        if (this.doubleNewline) {
            return exportString.toString().replaceAll("\n", "\n\n");
        }
        return exportString.toString().replaceAll("\n", "  \n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Insertion
    implements Comparable<Insertion> {
        String content;
        int position;

        public Insertion(String content, int position) {
            this.content = content;
            this.position = position;
        }

        @Override
        public int compareTo(Insertion o) {
            if (this.position == o.position) {
                return -1;
            }
            return -Integer.compare(this.position, o.position);
        }
    }
}

