/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.resource.ResourceInitializationException;

public abstract class DatabaseAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_HOSTNAME = "Hostname";
    public static final String PARAM_DBNAME = "DBname";
    public static final String PARAM_DBUSER = "DBuser";
    public static final String PARAM_DBPASS = "DBpassword";
    @ConfigurationParameter(name="DBuser")
    String databaseUsername;
    @ConfigurationParameter(name="DBpassword")
    String databasePassword;
    @ConfigurationParameter(name="Hostname")
    String databaseHostname;
    @ConfigurationParameter(name="DBname")
    String databaseName;
    DataSource dataSource;
    Connection connection;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            Class.forName("com.mysql.jdbc.Driver");
            BasicDataSource bds = new BasicDataSource();
            bds.setDriverClassName("com.mysql.jdbc.Driver");
            bds.setUsername(this.databaseUsername);
            bds.setPassword(this.databasePassword);
            bds.setUrl("jdbc:mysql://" + this.databaseHostname + "/" + this.databaseName);
            this.dataSource = bds;
            this.connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }
}

