/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import de.unistuttgart.ims.uimautil.AbstractWindowAnnotator;
import java.util.Comparator;
import java.util.TreeMap;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class ContextWindowAnnotator
extends AbstractWindowAnnotator {
    public static final String PARAM_CONTEXT_CLASS = "Context class";
    public static final String PARAM_CONTEXT_SIZE_LEFT = "Left context size";
    public static final String PARAM_CONTEXT_SIZE_RIGHT = "Right context size";
    @ConfigurationParameter(name="Context class", defaultValue={"de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Sentence"})
    String contextClassName;
    Class<? extends Annotation> contextClass;
    @ConfigurationParameter(name="Left context size", mandatory=false, defaultValue={"3"})
    int leftContextSize = 3;
    @ConfigurationParameter(name="Right context size", mandatory=false, defaultValue={"3"})
    int rightContextSize = 3;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.contextClass = Class.forName(this.contextClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        TreeMap<Annotation, Boolean> map = new TreeMap<Annotation, Boolean>(new Comparator<Annotation>(){

            @Override
            public int compare(Annotation o1, Annotation o2) {
                return Integer.compare(o1.getBegin(), o2.getBegin());
            }
        });
        for (Annotation s : JCasUtil.select((JCas)jcas, this.contextClass)) {
            map.put(s, false);
        }
        for (Annotation s : JCasUtil.select((JCas)jcas, this.contextClass)) {
            if (JCasUtil.selectCovered((Class)this.baseAnnotation, (AnnotationFS)s).size() <= 0) continue;
            this.getLogger().debug((Object)("Contexting sentence " + s));
            map.put(s, true);
            for (Annotation s1 : JCasUtil.selectPreceding(this.contextClass, (AnnotationFS)s, (int)this.leftContextSize)) {
                this.getLogger().debug((Object)("Contexting sentence " + s1));
                map.put(s1, true);
            }
            for (Annotation s2 : JCasUtil.selectFollowing(this.contextClass, (AnnotationFS)s, (int)this.rightContextSize)) {
                this.getLogger().debug((Object)("Contexting sentence " + s2));
                map.put(s2, true);
            }
        }
        int begin = -1;
        Annotation lastSentence = null;
        for (Annotation s : map.keySet()) {
            if (((Boolean)map.get(s)).booleanValue() && begin < 0) {
                begin = s.getBegin();
            } else if (!((Boolean)map.get(s)).booleanValue() && begin >= 0) {
                AnnotationFactory.createAnnotation((JCas)jcas, (int)begin, (int)lastSentence.getEnd(), (Class)this.targetAnnotation);
                begin = -1;
            }
            lastSentence = s;
        }
    }
}

