/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import de.tudarmstadt.ukp.dkpro.core.api.metadata.type.DocumentMetaData;
import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Token;
import de.unistuttgart.ims.uimautil.export.CoveredExportEntry;
import de.unistuttgart.ims.uimautil.export.ExportEntry;
import de.unistuttgart.ims.uimautil.export.FeaturePathExportEntry;
import de.unistuttgart.ims.uimautil.export.PrimitiveExportEntry;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.OverrideCombiner;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.uima.UIMAException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.component.JCasConsumer_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OperationalProperties(multipleDeploymentAllowed=false)
public class CoNLLStyleExporter
extends JCasConsumer_ImplBase {
    public static final String PARAM_OUTPUT_FILE = "Output File";
    public static final String PARAM_CONFIGURATION_FILE = "Configuration URL";
    public static final String PARAM_ANNOTATION_CLASS = "Annotation Class";
    public static final String PARAM_FEATURE_PATHS = "Feature Paths";
    public static final String PARAM_COLUMN_LABELS = "Feature Path Labels";
    public static final String PARAM_COVERED_ANNOTATION_CLASS = "Covered Annotation Class";
    @ConfigurationParameter(name="Output File", mandatory=true)
    File outputFile;
    @ConfigurationParameter(name="Annotation Class", defaultValue={"de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Token"})
    String annotationClassName;
    @ConfigurationParameter(name="Configuration URL")
    String configurationFile;
    @ConfigurationParameter(name="Covered Annotation Class", mandatory=false)
    String coveredAnnotationClassName = null;
    CSVPrinter csvPrinter;
    List<ExportEntry> eelist;
    Class<? extends Annotation> annotationClass;
    Class<? extends Annotation> coveredAnnotationClass = null;
    CombinedConfiguration config;
    Type type;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        TypeSystemDescription tsd;
        JCas jcas;
        super.initialize(context);
        try {
            this.csvPrinter = new CSVPrinter((Appendable)new FileWriter(this.outputFile), CSVFormat.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ResourceInitializationException((Throwable)e);
        }
        INIConfiguration defaultConfig = new INIConfiguration();
        INIConfiguration serverConfig = new INIConfiguration();
        InputStream is = null;
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream("/project.properties");
            if (is != null) {
                defaultConfig.read((Reader)new InputStreamReader(is, "UTF-8"));
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new ResourceInitializationException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)is);
        try {
            URL url = new URL(this.configurationFile);
            is = url.openStream();
            serverConfig.read((Reader)new InputStreamReader(is, "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceInitializationException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)is);
        }
        this.config = new CombinedConfiguration((NodeCombiner)new OverrideCombiner());
        this.config.addConfiguration((Configuration)serverConfig);
        this.config.addConfiguration((Configuration)defaultConfig);
        Class<?> cl = null;
        try {
            cl = Class.forName(this.annotationClassName);
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
            throw new ResourceInitializationException((Throwable)e2);
        }
        if (cl != null) {
            this.annotationClass = cl;
        }
        cl = null;
        if (this.coveredAnnotationClassName != null) {
            try {
                cl = Class.forName(this.coveredAnnotationClassName);
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
                throw new ResourceInitializationException((Throwable)e2);
            }
        }
        if (cl != null) {
            this.coveredAnnotationClass = cl;
        }
        try {
            jcas = JCasFactory.createJCas();
            tsd = TypeSystemDescriptionFactory.createTypeSystemDescription();
        }
        catch (UIMAException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        TypeDescription td = tsd.getType(this.annotationClass.getName());
        this.type = jcas.getTypeSystem().getType(td.getName());
        Type coveredType = null;
        if (this.coveredAnnotationClass != null) {
            coveredType = jcas.getTypeSystem().getType(this.coveredAnnotationClass.getName());
        }
        this.eelist = this.getExportEntries(jcas, this.type, coveredType);
        String confKey = this.type.getName().replaceAll("\\.", "..") + ".fixed";
        String[] confValues = this.config.getString(confKey, "").split(",");
        String[] confValueLabels = this.config.getString(confKey + "_labels", "").split(",");
        for (int i = 0; i < confValues.length; ++i) {
            String confEntry = confValues[i].trim();
            String confEntryLabel = confValueLabels[i].trim();
            if (confEntry.equalsIgnoreCase("DocumentId")) {
                this.eelist.add(0, new ExportEntry(new String[]{confEntryLabel}){

                    public Object getValue(Annotation a) {
                        try {
                            return DocumentMetaData.get((CAS)a.getCAS()).getDocumentId();
                        }
                        catch (Exception e) {
                            return "";
                        }
                    }

                    public boolean isMultiplying() {
                        return false;
                    }
                });
                continue;
            }
            if (!confEntry.equalsIgnoreCase("Length")) continue;
            this.eelist.add(0, new ExportEntry(new String[]{confEntryLabel}){

                public Object getValue(Annotation a) {
                    try {
                        JCas jcas = a.getCAS().getJCas();
                        return JCasUtil.select((JCas)jcas, Token.class).size();
                    }
                    catch (CASException e) {
                        e.printStackTrace();
                        return 0;
                    }
                }

                public boolean isMultiplying() {
                    return false;
                }
            });
        }
        LinkedList<String> header = new LinkedList<String>();
        for (ExportEntry ee : this.eelist) {
            for (String s : ee.getLabel()) {
                header.add(s);
            }
        }
        try {
            this.csvPrinter.printRecord(header);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        Collection annotationList = JCasUtil.select((JCas)jcas, this.annotationClass);
        for (Annotation a : annotationList) {
            for (List list : this.printFeatureValues(a, this.eelist.iterator())) {
                try {
                    this.csvPrinter.printRecord((Iterable)list);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        try {
            this.csvPrinter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        IOUtils.closeQuietly((Closeable)this.csvPrinter);
    }

    private ArrayList<ArrayList<Object>> printFeatureValues(Annotation a, Iterator<ExportEntry> eelist) {
        ArrayList<ArrayList<Object>> r = new ArrayList<ArrayList<Object>>();
        r.add(new ArrayList());
        while (eelist.hasNext()) {
            ExportEntry ee = eelist.next();
            Object value = ee.getValue(a);
            if (ee.isMultiplying()) {
                int j;
                ArrayList<ArrayList<ArrayList<Object>>> clones = new ArrayList<ArrayList<ArrayList<Object>>>();
                Object[] objectArray = (Object[])value;
                for (j = 1; j < objectArray.length; ++j) {
                    clones.add(this.deepClone(r));
                }
                for (List list : r) {
                    if (objectArray.length == 0) {
                        list.add("");
                        continue;
                    }
                    for (Object o : (Object[])objectArray[0]) {
                        list.add(o);
                    }
                }
                for (j = 1; j < objectArray.length; ++j) {
                    for (ArrayList l : (ArrayList)clones.get(j - 1)) {
                        for (Object o : (Object[])objectArray[j]) {
                            l.add(o);
                        }
                    }
                    r.addAll((Collection)clones.get(j - 1));
                }
                continue;
            }
            for (List list : r) {
                list.add(value);
            }
        }
        return r;
    }

    private String[] getExportPathsForType(Type type) {
        String confKey = type.getName().replaceAll("\\.", "..") + ".paths";
        String confEntry = this.config.getString(confKey, null);
        if (confEntry != null && !confEntry.isEmpty()) {
            return confEntry.split(",");
        }
        return new String[0];
    }

    private String[] getPathLabelsForType(Type type) {
        String confKey = type.getName().replaceAll("\\.", "..") + ".labels";
        String confEntry = this.config.getString(confKey, null);
        if (confEntry != null && !confEntry.isEmpty()) {
            return confEntry.split(",");
        }
        return new String[0];
    }

    private ArrayList<ArrayList<Object>> deepClone(ArrayList<ArrayList<Object>> list) {
        ArrayList<ArrayList<Object>> ret = new ArrayList<ArrayList<Object>>();
        for (ArrayList<Object> l : list) {
            ret.add((ArrayList)l.clone());
        }
        return ret;
    }

    protected List<ExportEntry> getExportEntries(JCas jcas, Type type, Type coveredType) {
        LinkedList<ExportEntry> eelist = new LinkedList<ExportEntry>();
        for (Feature fd : type.getFeatures()) {
            if (!fd.getRange().isPrimitive()) continue;
            PrimitiveExportEntry pee = new PrimitiveExportEntry(jcas.getTypeSystem().getFeatureByFullName(fd.getName()));
            eelist.add(pee);
        }
        String[] paths = this.getExportPathsForType(type);
        String[] labels = this.getPathLabelsForType(type);
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            FeaturePath fp = jcas.createFeaturePath();
            try {
                fp.initialize(path);
                fp.typeInit(type);
                if (labels.length > i) {
                    eelist.add(new FeaturePathExportEntry(fp, labels[i]));
                    continue;
                }
                eelist.add(new FeaturePathExportEntry(fp));
                continue;
            }
            catch (CASException e) {
                e.printStackTrace();
            }
        }
        String[] covTypes = this.getCoveringsForType(type);
        for (int j = 0; j < covTypes.length; ++j) {
            paths = this.getExportPathsForType(jcas.getTypeSystem().getType(covTypes[j]));
            labels = this.getPathLabelsForType(jcas.getTypeSystem().getType(covTypes[j]));
            FeaturePath[] path = new FeaturePath[paths.length];
            for (int i = 0; i < path.length; ++i) {
                path[i] = jcas.createFeaturePath();
                try {
                    labels[i] = Class.forName(covTypes[j]).getSimpleName() + "/" + labels[i];
                }
                catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                }
                try {
                    path[i].initialize(paths[i]);
                    path[i].typeInit(jcas.getTypeSystem().getType(covTypes[j]));
                    continue;
                }
                catch (CASException e) {
                    e.printStackTrace();
                }
            }
            try {
                CoveredExportEntry ee = new CoveredExportEntry(Class.forName(covTypes[j]), path);
                ee.setLabel(labels);
                eelist.add(ee);
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (coveredType != null) {
            labels = this.getPathLabelsForType(coveredType);
            paths = this.getExportPathsForType(coveredType);
            FeaturePath[] path = new FeaturePath[paths.length];
            for (int i = 0; i < path.length; ++i) {
                path[i] = jcas.createFeaturePath();
                try {
                    labels[i] = coveredType.getShortName() + "/" + labels[i];
                    path[i].initialize(paths[i]);
                    path[i].typeInit(coveredType);
                    continue;
                }
                catch (CASException e) {
                    e.printStackTrace();
                }
            }
            try {
                CoveredExportEntry ee = new CoveredExportEntry(Class.forName(coveredType.getName()), path);
                ee.setLabel(labels);
                eelist.add(ee);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return eelist;
    }

    protected String[] getCoveringsForType(Type type) {
        String confKey = type.getName().replaceAll("\\.", "..") + ".covered";
        String confEntry = this.config.getString(confKey, null);
        if (confEntry != null && !confEntry.isEmpty()) {
            return confEntry.split(",");
        }
        return new String[0];
    }
}

