/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Lemma;
import de.unistuttgart.ims.uimautil.WordListDescription;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.component.Resource_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;

public class WordListTagger
extends JCasAnnotator_ImplBase {
    public static final String RESOURCE_WORDLIST = "Word List";
    public static final String PARAM_BASE_ANNOTATION = "Base Annotation";
    public static final String PARAM_TARGET_ANNOTATION = "Target Annotation";
    public static final String PARAM_TARGET_FEATURE = "Target Feature";
    public static final String PARAM_CI = "Casing";
    public static final String PARAM_LEMMA = "Lemma";
    @ExternalResource(key="Word List", mandatory=true)
    WordList wordList;
    @ConfigurationParameter(name="Base Annotation", mandatory=false)
    String baseAnnotationClassName = null;
    @ConfigurationParameter(name="Target Annotation", mandatory=true)
    String targetAnnotationClassName = null;
    @ConfigurationParameter(name="Target Feature", mandatory=false)
    String targetFeatureName = null;
    @ConfigurationParameter(name="Casing", mandatory=false, defaultValue={"false"})
    boolean caseIndependent = false;
    @ConfigurationParameter(name="Lemma", mandatory=false, defaultValue={"false"})
    boolean listContainsLemmas = false;
    Class<? extends Annotation> targetAnnotation = null;
    Class<? extends Annotation> baseAnnotation = null;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        block6: {
            Class<?> tA;
            super.initialize(context);
            try {
                tA = Class.forName(this.targetAnnotationClassName);
                if (!Annotation.class.isAssignableFrom(tA)) {
                    throw new ResourceInitializationException();
                }
                this.targetAnnotation = tA;
            }
            catch (ClassNotFoundException e1) {
                throw new ResourceInitializationException((Throwable)e1);
            }
            try {
                if (this.baseAnnotationClassName == null) break block6;
                tA = Class.forName(this.baseAnnotationClassName);
                if (Annotation.class.isAssignableFrom(tA)) {
                    this.baseAnnotation = tA;
                    break block6;
                }
                throw new ResourceInitializationException();
            }
            catch (ClassNotFoundException e1) {
                throw new ResourceInitializationException((Throwable)e1);
            }
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        WordListDescription desc = (WordListDescription)AnnotationFactory.createAnnotation((JCas)jcas, (int)0, (int)0, WordListDescription.class);
        desc.setLength(this.wordList.getLength(this.caseIndependent));
        desc.setName(this.wordList.listName);
        Feature feature = null;
        if (this.targetFeatureName != null) {
            feature = jcas.getTypeSystem().getType(this.targetAnnotationClassName).getFeatureByBaseName(this.targetFeatureName);
        }
        if (this.baseAnnotation != null) {
            for (Annotation anno : JCasUtil.select((JCas)jcas, this.baseAnnotation)) {
                String s;
                if (this.listContainsLemmas) {
                    try {
                        s = ((Lemma)JCasUtil.selectCovered(Lemma.class, (AnnotationFS)anno).get(0)).getCoveredText();
                    }
                    catch (Exception e) {
                        s = anno.getCoveredText();
                    }
                } else {
                    s = anno.getCoveredText();
                }
                if (!this.wordList.contains(s, this.caseIndependent)) continue;
                Annotation newAnno = AnnotationFactory.createAnnotation((JCas)jcas, (int)anno.getBegin(), (int)anno.getEnd(), this.targetAnnotation);
                if (feature == null) continue;
                newAnno.setFeatureValueFromString(feature, this.wordList.listName);
            }
        } else {
            HashSet<String> words = this.caseIndependent ? this.wordList.lowerWords : this.wordList.words;
            for (String s : words) {
                Pattern pattern = Pattern.compile("\\b" + s + "\\b", 0x40 | (this.caseIndependent ? 2 : 0));
                Matcher matcher = pattern.matcher(jcas.getDocumentText());
                while (matcher.find()) {
                    Annotation newAnno = AnnotationFactory.createAnnotation((JCas)jcas, (int)matcher.start(), (int)matcher.end(), this.targetAnnotation);
                    if (feature == null) continue;
                    newAnno.setFeatureValueFromString(feature, this.wordList.listName);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WordList
    extends Resource_ImplBase {
        public static final String PARAM_SOURCE_URL = "Word List URL";
        public static final String PARAM_LIST_NAME = "Word List Name";
        @ConfigurationParameter(name="Word List URL", mandatory=true)
        String resourceURL = null;
        @ConfigurationParameter(name="Word List Name", mandatory=false)
        String listName = null;
        HashSet<String> words;
        HashSet<String> lowerWords;

        public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
            super.initialize(aSpecifier, aAdditionalParams);
            try {
                this.loadFromStream(new URL(this.resourceURL).openStream());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            if (this.listName == null) {
                this.listName = this.resourceURL;
            }
            return true;
        }

        public boolean contains(String s, boolean ci) {
            if (ci) {
                return this.lowerWords.contains(s.toLowerCase());
            }
            return this.words.contains(s);
        }

        public void loadFromStream(InputStream is) throws IOException {
            this.words = new HashSet(IOUtils.readLines((InputStream)is, (String)"UTF-8"));
            this.lowerWords = new HashSet();
            for (String s : this.words) {
                this.lowerWords.add(s.toLowerCase());
            }
        }

        public void afterResourcesInitialized() throws ResourceInitializationException {
        }

        public int getLength(boolean ci) {
            if (ci) {
                return this.lowerWords.size();
            }
            return this.lowerWords.size();
        }
    }
}

