/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.ExternalResourceAware;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.SharedResourceObject;

public class WordListTagger
extends JCasAnnotator_ImplBase {
    public static final String RESOURCE_WORDLIST = "Word List";
    public static final String PARAM_BASE_ANNOTATION = "Base Annotation";
    public static final String PARAM_TARGET_ANNOTATION = "Target Annotation";
    public static final String PARAM_CI = "Casing";
    @ExternalResource(key="Word List", mandatory=true)
    WordList wordList;
    @ConfigurationParameter(name="Base Annotation", mandatory=false)
    String baseAnnotationClassName = null;
    @ConfigurationParameter(name="Target Annotation", mandatory=true)
    String targetAnnotationClassName = null;
    @ConfigurationParameter(name="Casing", mandatory=false, defaultValue={"false"})
    boolean caseIndependent = false;
    Class<? extends Annotation> targetAnnotation = null;
    Class<? extends Annotation> baseAnnotation = null;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        block6: {
            Class<?> tA;
            super.initialize(context);
            try {
                tA = Class.forName(this.targetAnnotationClassName);
                if (!Annotation.class.isAssignableFrom(tA)) {
                    throw new ResourceInitializationException();
                }
                this.targetAnnotation = tA;
            }
            catch (ClassNotFoundException e1) {
                throw new ResourceInitializationException((Throwable)e1);
            }
            try {
                if (this.baseAnnotationClassName == null) break block6;
                tA = Class.forName(this.baseAnnotationClassName);
                if (Annotation.class.isAssignableFrom(tA)) {
                    this.baseAnnotation = tA;
                    break block6;
                }
                throw new ResourceInitializationException();
            }
            catch (ClassNotFoundException e1) {
                throw new ResourceInitializationException((Throwable)e1);
            }
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        if (this.baseAnnotation != null) {
            for (Annotation anno : JCasUtil.select((JCas)jcas, this.baseAnnotation)) {
                if (!this.wordList.contains(anno.getCoveredText(), this.caseIndependent)) continue;
                AnnotationFactory.createAnnotation((JCas)jcas, (int)anno.getBegin(), (int)anno.getEnd(), this.targetAnnotation);
            }
        } else {
            HashSet<String> words = this.caseIndependent ? this.wordList.lowerWords : this.wordList.words;
            for (String s : words) {
                Pattern pattern = Pattern.compile("\\b" + s + "\\b", 0x40 | (this.caseIndependent ? 2 : 0));
                Matcher matcher = pattern.matcher(jcas.getDocumentText());
                while (matcher.find()) {
                    AnnotationFactory.createAnnotation((JCas)jcas, (int)matcher.start(), (int)matcher.end(), this.targetAnnotation);
                }
            }
        }
    }

    public static class WordList
    implements SharedResourceObject,
    ExternalResourceAware {
        @ConfigurationParameter(name="__UIMAFIT_RESOURCE_NAME__")
        private String resourceName;
        HashSet<String> words;
        HashSet<String> lowerWords;

        public String getResourceName() {
            return this.resourceName;
        }

        public boolean contains(String s, boolean ci) {
            if (ci) {
                return this.lowerWords.contains(s.toLowerCase());
            }
            return this.words.contains(s);
        }

        public void load(DataResource aData) throws ResourceInitializationException {
            try {
                this.loadFromStream(aData.getInputStream());
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }

        public void loadFromStream(InputStream is) throws IOException {
            this.words = new HashSet(IOUtils.readLines((InputStream)is, (String)"UTF-8"));
            this.lowerWords = new HashSet();
            for (String s : this.words) {
                this.lowerWords.add(s.toLowerCase());
            }
        }

        public void afterResourcesInitialized() throws ResourceInitializationException {
        }
    }
}

