/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import java.util.HashSet;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class MapAnnotations
extends JCasAnnotator_ImplBase {
    public static final String PARAM_SOURCE_CLASS = "Source Class";
    public static final String PARAM_TARGET_CLASS = "Target Class";
    public static final String PARAM_DELETE_SOURCE = "Delete Source";
    @ConfigurationParameter(name="Target Class")
    String targetClassName;
    @ConfigurationParameter(name="Source Class")
    String sourceClassName;
    @ConfigurationParameter(name="Delete Source", mandatory=false, defaultValue={"false"})
    boolean deleteSource = false;
    Class<? extends Annotation> sourceClass;
    Class<? extends Annotation> targetClass;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.sourceClass = Class.forName(this.sourceClassName);
            this.targetClass = Class.forName(this.targetClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        HashSet<Annotation> toDelete = null;
        if (this.deleteSource) {
            toDelete = new HashSet<Annotation>();
        }
        for (Annotation anno : JCasUtil.select((JCas)jcas, this.sourceClass)) {
            AnnotationFactory.createAnnotation((JCas)jcas, (int)anno.getBegin(), (int)anno.getEnd(), this.targetClass);
            if (!this.deleteSource) continue;
            toDelete.add(anno);
        }
        if (this.deleteSource) {
            for (Annotation a : toDelete) {
                a.removeFromIndexes();
            }
        }
    }
}

