/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uimautil;

import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.uima.jcas.tcas.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtil {
    static Pattern pattern = null;

    public static <T extends Annotation> T trim(T annotation, char ... ws) {
        char[] s = annotation.getCoveredText().toCharArray();
        if (s.length == 0) {
            return annotation;
        }
        int b = 0;
        while (ArrayUtils.contains((char[])ws, (char)s[b])) {
            ++b;
        }
        int e = 0;
        while (ArrayUtils.contains((char[])ws, (char)s[s.length - 1 - e])) {
            ++e;
        }
        annotation.setBegin(annotation.getBegin() + b);
        annotation.setEnd(annotation.getEnd() - e);
        return annotation;
    }

    public static <T extends Annotation> T trim(T annotation) {
        if (pattern == null) {
            pattern = Pattern.compile("\\S");
        }
        if (!pattern.matcher(annotation.getCoveredText()).find()) {
            return annotation;
        }
        return AnnotationUtil.trim(annotation, ' ', '\n', '\t', '\r', '\f');
    }

    public static <T extends Annotation> void trim(Collection<T> annotations) {
        for (Annotation anno : annotations) {
            AnnotationUtil.trim(anno, ' ', '\n', '\t', '\r', '\f');
        }
    }

    public static <T extends Annotation> T trimFront(T annotation, char ... ws) {
        char[] s = annotation.getCoveredText().toCharArray();
        if (s.length == 0) {
            return annotation;
        }
        int b = 0;
        while (ArrayUtils.contains((char[])ws, (char)s[b])) {
            ++b;
        }
        annotation.setBegin(annotation.getBegin() + b);
        return annotation;
    }
}

