/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uima.io.xml;

import de.unistuttgart.ims.uima.io.xml.ArrayUtil;
import de.unistuttgart.ims.uima.io.xml.Visitor;
import de.unistuttgart.ims.uima.io.xml.type.XMLElement;
import de.unistuttgart.ims.uima.io.xml.type.XMLParsingDescription;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeVisitor;

public class GenericXmlReader<D extends TOP> {
    Document doc;
    String textRootSelector = null;
    boolean preserveWhitespace = false;
    List<Rule> elementMapping = new LinkedList<Rule>();
    Map<String, Map.Entry<Element, FeatureStructure>> idRegistry = new HashMap<String, Map.Entry<Element, FeatureStructure>>();
    Class<D> documentClass;

    public GenericXmlReader(Class<D> documentClass) {
        this.documentClass = documentClass;
    }

    public JCas read(JCas jcas, InputStream xmlStream) throws IOException {
        this.doc = Jsoup.parse((InputStream)xmlStream, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
        Visitor vis = new Visitor(jcas, this.isPreserveWhitespace());
        Object root = this.textRootSelector == null ? this.doc : this.doc.select(this.textRootSelector).first();
        root.traverse((NodeVisitor)vis);
        vis.getJCas();
        for (Rule mapping : this.elementMapping) {
            this.applyRule(jcas, (Element)(mapping.isGlobal() ? this.doc : root), vis.getAnnotationMap(), mapping);
        }
        XMLParsingDescription parsingDescription = new XMLParsingDescription(jcas);
        parsingDescription.setEncoding(this.doc.charset().name());
        Node rootNode = this.doc.root();
        LinkedList<String> declarations = new LinkedList<String>();
        for (Node topNode : rootNode.childNodes()) {
            if (!(topNode instanceof XmlDeclaration)) continue;
            XmlDeclaration xmlDecl = (XmlDeclaration)topNode;
            declarations.add(xmlDecl.getWholeDeclaration());
        }
        parsingDescription.setXmlDeclarations(ArrayUtil.toStringArray(jcas, declarations));
        parsingDescription.addToIndexes();
        return jcas;
    }

    public void addRule(Rule<?> rule) {
        this.elementMapping.add(rule);
    }

    public <T extends TOP> void addRule(String selector, Class<T> targetClass) {
        this.elementMapping.add(new Rule<T>(selector, targetClass, null));
    }

    public <T extends TOP> void addRule(String selector, Class<T> targetClass, BiConsumer<T, Element> callback) {
        this.elementMapping.add(new Rule<T>(selector, targetClass, callback));
    }

    public void addGlobalRule(String selector, BiConsumer<D, Element> callback) {
        Rule<D> r = new Rule<D>(selector, this.documentClass, callback, true);
        r.setUnique(true);
        this.elementMapping.add(r);
    }

    public <T extends TOP> void addGlobalRule(String selector, Class<T> targetClass, BiConsumer<T, Element> callback) {
        this.elementMapping.add(new Rule<T>(selector, targetClass, callback, true));
    }

    public Map.Entry<Element, FeatureStructure> getAnnotation(String id) {
        return this.idRegistry.get(id);
    }

    public boolean exists(String id) {
        return this.idRegistry.containsKey(id);
    }

    protected <T extends TOP> T getFeatureStructure(JCas jcas, XMLElement hAnno, Element elm, Rule<T> mapping) {
        TOP annotation = null;
        if (mapping.isUnique()) {
            annotation = (TOP)GenericXmlReader.getOrCreate(jcas, mapping.getTargetClass());
        } else {
            annotation = (TOP)jcas.getCas().createFS(JCasUtil.getType((JCas)jcas, mapping.getTargetClass()));
            jcas.getCas().addFsToIndexes((FeatureStructure)annotation);
            if (Annotation.class.isAssignableFrom(mapping.getTargetClass())) {
                ((Annotation)annotation).setBegin(hAnno.getBegin());
                ((Annotation)annotation).setEnd(hAnno.getEnd());
            }
            if (elm.hasAttr("xml:id") && !this.exists(elm.attr("xml:id"))) {
                String id = elm.attr("xml:id");
                this.idRegistry.put(id, new AbstractMap.SimpleEntry<Element, TOP>(elm, annotation));
            }
        }
        return (T)annotation;
    }

    protected <T extends TOP> void applyRule(JCas jcas, Element rootElement, Map<String, XMLElement> annoMap, Rule<T> mapping) {
        Elements elms = rootElement.select(mapping.getSelector());
        for (Element elm : elms) {
            XMLElement hAnno = annoMap.get(elm.cssSelector());
            if (!elm.hasText() && elm.childNodeSize() <= 0) continue;
            T annotation = this.getFeatureStructure(jcas, hAnno, elm, mapping);
            if (mapping.getCallback() == null || annotation == null) continue;
            mapping.getCallback().accept(annotation, elm);
        }
    }

    public String getTextRootSelector() {
        return this.textRootSelector;
    }

    public void setTextRootSelector(String textRootSelector) {
        this.textRootSelector = textRootSelector;
    }

    public Document getDocument() {
        return this.doc;
    }

    public boolean isPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    public void setPreserveWhitespace(boolean preserveWhitespace) {
        this.preserveWhitespace = preserveWhitespace;
    }

    public static <T extends TOP> T getOrCreate(JCas jcas, Class<T> targetClass) {
        if (JCasUtil.exists((JCas)jcas, targetClass)) {
            return (T)JCasUtil.selectSingle((JCas)jcas, targetClass);
        }
        TOP annotation = (TOP)jcas.getCas().createFS(JCasUtil.getType((JCas)jcas, targetClass));
        jcas.getCas().addFsToIndexes((FeatureStructure)annotation);
        return (T)annotation;
    }

    public static class Rule<T extends TOP> {
        String selector;
        BiConsumer<T, Element> callback;
        Class<T> targetClass;
        boolean global;
        boolean unique = false;

        public Rule(String selector, Class<T> targetClass, BiConsumer<T, Element> callback, boolean global) {
            this.selector = selector;
            this.callback = callback;
            this.targetClass = targetClass;
            this.global = global;
        }

        public Rule(String selector, Class<T> targetClass, BiConsumer<T, Element> callback) {
            this.selector = selector;
            this.callback = callback;
            this.targetClass = targetClass;
            this.global = false;
        }

        public Class<T> getTargetClass() {
            return this.targetClass;
        }

        public String getSelector() {
            return this.selector;
        }

        boolean isGlobal() {
            return this.global;
        }

        public String toString() {
            return this.getSelector() + " -> " + this.getTargetClass().getName();
        }

        public BiConsumer<T, Element> getCallback() {
            return this.callback;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public void setUnique(boolean singleton) {
            this.unique = singleton;
        }
    }
}

