/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uima.io.xml;

import de.unistuttgart.ims.uima.io.xml.AnnotationChooser;
import de.unistuttgart.ims.uima.io.xml.InlineTagFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class GenericInlineWriter<S extends Annotation> {
    Class<S> annotationClass;
    InlineTagFactory<S> tagFactory;

    public GenericInlineWriter(Class<S> clz) {
        this.annotationClass = clz;
    }

    public void write(JCas jcas, Appendable os) {
        this.write(jcas, os, 0, jcas.getDocumentText().length());
    }

    public void write(JCas jcas, OutputStream os) {
        this.write(jcas, os, 0, jcas.getDocumentText().length());
    }

    public void write(JCas jcas, OutputStream os, int begin, int end) {
        try (OutputStreamWriter fos = new OutputStreamWriter(os);){
            this.write(jcas, fos, begin, end);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(JCas jcas, Appendable os, int begin, int end) {
        StringBuilder b = new StringBuilder(jcas.getDocumentText().substring(begin, end));
        Annotation a = new Annotation(jcas);
        a.setBegin(begin);
        a.setEnd(end);
        List htmls = JCasUtil.selectCovered((JCas)jcas, this.annotationClass, (AnnotationFS)a);
        HashMap positions = new HashMap();
        for (Annotation h : htmls) {
            if (!positions.containsKey(h.getBegin() - begin)) {
                positions.put(h.getBegin() - begin, new LinkedList());
            }
            ((List)positions.get(h.getBegin() - begin)).add(h);
            if (h.getBegin() - begin == h.getEnd() - begin) continue;
            if (!positions.containsKey(h.getEnd() - begin)) {
                positions.put(h.getEnd() - begin, new LinkedList());
            }
            ((List)positions.get(h.getEnd() - begin)).add(h);
        }
        for (int i = b.length() + 10; i >= 0; --i) {
            int currentPos = i;
            if (!positions.containsKey(i)) continue;
            TreeSet<Annotation> ts = new TreeSet<Annotation>(new AnnotationChooser(currentPos));
            ts.addAll((Collection)positions.get(i));
            for (Annotation nodeAnno : ts) {
                if (nodeAnno.getEnd() == nodeAnno.getBegin() && nodeAnno.getBegin() - begin == i) {
                    b.insert(i, this.tagFactory.getEmptyTag(nodeAnno));
                    continue;
                }
                if (nodeAnno.getEnd() - begin == i) {
                    b.insert(i, this.tagFactory.getEndTag(nodeAnno));
                    continue;
                }
                if (nodeAnno.getBegin() - begin != i) continue;
                b.insert(i, this.tagFactory.getBeginTag(nodeAnno));
            }
        }
        try {
            os.append(b.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Class<S> getAnnotationClass() {
        return this.annotationClass;
    }

    public void setAnnotationClass(Class<S> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public InlineTagFactory<S> getTagFactory() {
        return this.tagFactory;
    }

    public void setTagFactory(InlineTagFactory<S> tagFactory) {
        this.tagFactory = tagFactory;
    }
}

