/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.uima.weka;

import de.tudarmstadt.ukp.dkpro.core.api.io.JCasFileWriter_ImplBase;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.StringToNominal;

public class DocumentArffConsumer
extends JCasFileWriter_ImplBase {
    public static final String PARAM_ANNOTATION_TYPE = "Annotation Type";
    public static final String PARAM_DATASET_NAME = "Dataset Name";
    public static final String PARAM_CLASS_FEATURE = "Class Feature";
    public static final String PARAM_CONVERT_CLASS = "Convert Class To Nominal";
    @ConfigurationParameter(name="Annotation Type", mandatory=true)
    String annotationType = null;
    @ConfigurationParameter(name="Dataset Name", mandatory=false, defaultValue={"Data Set"})
    String datasetName = "Data Set";
    @ConfigurationParameter(name="Class Feature", mandatory=true)
    String classFeatureName;
    @ConfigurationParameter(name="Convert Class To Nominal", mandatory=false)
    boolean convertClass = false;
    TypeDescription typeDescription;
    FastVector attributes;
    Map<String, Integer> attributeMap;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.attributeMap = new HashMap<String, Integer>();
        this.attributes = new FastVector();
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription();
        this.typeDescription = tsd.getType(this.annotationType);
        Attribute classAttribute = null;
        if (this.typeDescription == null) {
            throw new ResourceInitializationException("could_not_instantiate", (Object[])new String[]{this.annotationType});
        }
        FeatureDescription[] fds = this.typeDescription.getFeatures();
        int f = 0;
        for (int i = 0; i < fds.length; ++i) {
            Attribute attr = null;
            FeatureDescription fd = fds[i];
            if (fd.getName().equals(this.classFeatureName)) {
                classAttribute = this.makeAttribute(fd);
            } else {
                attr = this.makeAttribute(fd);
            }
            if (attr == null) continue;
            this.attributes.addElement((Object)attr);
            this.attributeMap.put(fd.getName(), f++);
        }
        this.attributes.addElement(classAttribute);
        this.attributeMap.put(this.classFeatureName, f);
    }

    protected Attribute makeAttribute(FeatureDescription fd) {
        String rangeTypeName = fd.getRangeTypeName();
        Attribute attr = null;
        if (rangeTypeName.equals("uima.cas.String")) {
            attr = new Attribute(fd.getName(), (FastVector)null);
        } else if (rangeTypeName.equals("uima.cas.Integer")) {
            attr = new Attribute(fd.getName());
        } else if (rangeTypeName.equals("uima.cas.Double")) {
            attr = new Attribute(fd.getName());
        } else if (rangeTypeName.equals("uima.cas.Boolean")) {
            attr = new Attribute(fd.getName());
        }
        return attr;
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        Instances instances = new Instances(this.datasetName, this.attributes, 0);
        Class<?> cl = null;
        try {
            cl = Class.forName(this.annotationType);
        }
        catch (ClassNotFoundException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (ClassCastException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        Type type = jcas.getTypeSystem().getType(this.typeDescription.getName());
        for (Annotation anno : JCasUtil.select((JCas)jcas, cl)) {
            Instance instance = new Instance(this.attributes.size());
            instance.setDataset(instances);
            for (Feature feature : type.getFeatures()) {
                if (!feature.getDomain().equals(type)) continue;
                if (feature.getRange().getName().equals("uima.cas.String")) {
                    if (anno == null || anno.getFeatureValueAsString(feature) == null) {
                        instance.setMissing(this.attributeMap.get(feature.getShortName()).intValue());
                        continue;
                    }
                    instance.setValue(this.attributeMap.get(feature.getShortName()).intValue(), anno.getFeatureValueAsString(feature));
                    continue;
                }
                if (feature.getRange().getName().equals("uima.cas.Integer")) {
                    instance.setValue(this.attributeMap.get(feature.getShortName()).intValue(), (double)anno.getIntValue(feature));
                    continue;
                }
                if (feature.getRange().getName().equals("uima.cas.Double")) {
                    instance.setValue(this.attributeMap.get(feature.getShortName()).intValue(), anno.getDoubleValue(feature));
                    continue;
                }
                if (!feature.getRange().getName().equals("uima.cas.Boolean")) continue;
                instance.setValue(this.attributeMap.get(feature.getShortName()).intValue(), (double)(anno.getBooleanValue(feature) ? 1 : 0));
            }
            instances.add(instance);
        }
        if (this.convertClass) {
            StringToNominal filter = new StringToNominal();
            filter.setAttributeRange("first-last");
            try {
                filter.setInputFormat(instances);
                instances = Filter.useFilter((Instances)instances, (Filter)filter);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JCasFileWriter_ImplBase.NamedOutputStream aw = null;
        PrintStream ps = null;
        try {
            aw = this.getOutputStream(jcas, ".arff");
            ps = new PrintStream((OutputStream)aw);
            ps.print(instances.toString());
            ps.flush();
            aw.flush();
            ps.close();
            aw.close();
        }
        catch (IOException e) {
            try {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ps);
                IOUtils.closeQuietly((OutputStream)aw);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)ps);
        IOUtils.closeQuietly((OutputStream)aw);
    }
}

