/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.drama.util;

import de.unistuttgart.ims.drama.api.Author;
import de.unistuttgart.ims.drama.api.CastFigure;
import de.unistuttgart.ims.drama.api.DateReference;
import de.unistuttgart.ims.drama.api.Drama;
import de.unistuttgart.ims.drama.api.Figure;
import de.unistuttgart.ims.drama.api.FigureType;
import de.unistuttgart.ims.drama.api.Speaker;
import de.unistuttgart.ims.drama.api.Speech;
import de.unistuttgart.ims.drama.api.Utterance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

public class DramaUtil {
    public static Collection<Speech> getSpeeches(JCas jcas, Figure figure) {
        LinkedList<Speech> ret = new LinkedList<Speech>();
        for (Utterance u : JCasUtil.select((JCas)jcas, Utterance.class)) {
            Speaker sp = DramaUtil.getFirstSpeaker(u);
            if (sp == null || sp.getFigure() != figure) continue;
            ret.addAll(JCasUtil.selectCovered((JCas)jcas, Speech.class, (AnnotationFS)u));
        }
        return ret;
    }

    public static Collection<Speech> getSpeeches(JCas jcas, Figure figure, Annotation coveringAnnotation) {
        LinkedList<Speech> ret = new LinkedList<Speech>();
        for (Utterance u : JCasUtil.selectCovered((JCas)jcas, Utterance.class, (AnnotationFS)coveringAnnotation)) {
            Speaker sp = DramaUtil.getFirstSpeaker(u);
            if (sp == null || sp.getFigure() != figure) continue;
            ret.addAll(JCasUtil.selectCovered((JCas)jcas, Speech.class, (AnnotationFS)u));
        }
        return ret;
    }

    public static Collection<Speaker> getSpeakers(Utterance utterance) {
        try {
            return JCasUtil.selectCovered(Speaker.class, (AnnotationFS)utterance);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Speaker getFirstSpeaker(Utterance utterance) {
        try {
            return (Speaker)JCasUtil.selectCovered(Speaker.class, (AnnotationFS)utterance).get(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Collection<Figure> getFigures(Utterance u) {
        Collection<Speaker> s = DramaUtil.getSpeakers(u);
        LinkedList<Figure> f = new LinkedList<Figure>();
        for (Speaker speaker : s) {
            f.add(speaker.getFigure());
        }
        return f;
    }

    public static Collection<CastFigure> getCastFigures(Utterance u) {
        Collection<Speaker> s = DramaUtil.getSpeakers(u);
        LinkedList<CastFigure> f = new LinkedList<CastFigure>();
        for (Speaker speaker : s) {
            for (int i = 0; i < speaker.getCastFigure().size(); ++i) {
                f.add(speaker.getCastFigure(i));
            }
        }
        return f;
    }

    public static Figure getFirstFigure(Utterance u) {
        Speaker s = DramaUtil.getFirstSpeaker(u);
        if (s != null) {
            return s.getFigure();
        }
        return null;
    }

    public static Collection<Utterance> selectFullUtterances(JCas jcas) {
        Iterator baseIterator = JCasUtil.iterator((JCas)jcas, Utterance.class);
        ArrayList<Utterance> fullUtterances = new ArrayList<Utterance>();
        while (baseIterator.hasNext()) {
            Utterance utt = (Utterance)baseIterator.next();
            if (JCasUtil.selectCovered((JCas)jcas, Speaker.class, (AnnotationFS)utt).isEmpty() || ((Speaker)JCasUtil.selectCovered((JCas)jcas, Speaker.class, (AnnotationFS)utt).get(0)).getFigure() == null) continue;
            fullUtterances.add(utt);
        }
        return fullUtterances;
    }

    public static FigureType assignFigureType(JCas jcas, Figure figure, String cl, String value) {
        FigureType ft = (FigureType)AnnotationFactory.createAnnotation((JCas)jcas, (int)figure.getBegin(), (int)(figure.getBegin() + 1), FigureType.class);
        ft.setTypeClass(cl);
        ft.setTypeValue(value);
        return ft;
    }

    public static Collection<FigureType> getAllFigureTypes(Figure figure) {
        if (figure != null) {
            return JCasUtil.selectCovered(FigureType.class, (AnnotationFS)figure);
        }
        return new HashSet<FigureType>();
    }

    public static String getTypeValue(JCas jcas, Figure figure, String typeClass) {
        for (FigureType ft : JCasUtil.selectCovered(FigureType.class, (AnnotationFS)figure)) {
            if (!typeClass.equals(ft.getTypeClass())) continue;
            return ft.getTypeValue();
        }
        return null;
    }

    public static String getDisplayId(JCas jcas) {
        String title = ((Drama)JCasUtil.selectSingle((JCas)jcas, Drama.class)).getDocumentTitle();
        String author = "";
        if (JCasUtil.exists((JCas)jcas, Author.class)) {
            author = ((Author)JCasUtil.select((JCas)jcas, Author.class).iterator().next()).getName();
        }
        int date = 0;
        if (JCasUtil.exists((JCas)jcas, DateReference.class)) {
            date = ((DateReference)JCasUtil.selectSingle((JCas)jcas, DateReference.class)).getYear();
        }
        if (title == null || author == null || author.length() == 0 || title.length() == 0) {
            return ((Drama)JCasUtil.selectSingle((JCas)jcas, Drama.class)).getDocumentId();
        }
        StringBuilder b = new StringBuilder();
        if (date != 0) {
            b.append(date).append("_");
        }
        for (String s : author.split(" ")) {
            b.append(s.charAt(0));
        }
        b.append('_');
        for (String s : title.split(" ")) {
            b.append(s.charAt(0));
        }
        b.append("_");
        b.append(((Drama)JCasUtil.selectSingle((JCas)jcas, Drama.class)).getDocumentId());
        return b.toString();
    }

    public static <T extends TOP> T createFeatureStructure(JCas jcas, Class<T> cls) {
        TOP fs = (TOP)jcas.getCas().createFS(JCasUtil.getType((JCas)jcas, cls));
        fs.addToIndexes();
        return (T)fs;
    }

    public static Drama getDrama(JCas jcas) {
        if (JCasUtil.exists((JCas)jcas, Drama.class)) {
            return (Drama)JCasUtil.selectSingle((JCas)jcas, Drama.class);
        }
        Drama d = new Drama(jcas);
        d.addToIndexes();
        return d;
    }

    public static <T extends TOP> T getOrCreate(JCas jcas, Class<T> targetClass) {
        if (JCasUtil.exists((JCas)jcas, targetClass)) {
            return (T)JCasUtil.selectSingle((JCas)jcas, targetClass);
        }
        TOP annotation = (TOP)jcas.getCas().createFS(JCasUtil.getType((JCas)jcas, targetClass));
        jcas.getCas().addFsToIndexes((FeatureStructure)annotation);
        return (T)annotation;
    }
}

