/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.drama.main.annotation;

import de.tudarmstadt.ukp.dkpro.core.api.lexmorph.type.pos.POS;
import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Token;
import de.unistuttgart.ims.drama.api.Scene;
import de.unistuttgart.ims.drama.util.DramaUtil;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class PreparePosAnnotation
extends JCasAnnotator_ImplBase {
    public static final String PARAM_SCENE_BEGIN = "Scene Begin";
    public static final String PARAM_SCENE_END = "Scene End";
    @ConfigurationParameter(name="Scene Begin", defaultValue={"8"})
    int sceneBegin = 8;
    @ConfigurationParameter(name="Scene End", defaultValue={"11"})
    int sceneEnd = 11;

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        String did = DramaUtil.getDrama((JCas)aJCas).getDocumentId();
        this.prepareRksp0(aJCas);
    }

    public void prepareRksp0(JCas jcas) {
        int sceneNum = 1;
        for (Scene scene : JCasUtil.select((JCas)jcas, Scene.class)) {
            if (sceneNum >= this.sceneBegin && sceneNum < this.sceneEnd) {
                for (Token token : JCasUtil.selectCovered(Token.class, (AnnotationFS)scene)) {
                    AnnotationFactory.createAnnotation((JCas)jcas, (int)token.getBegin(), (int)token.getEnd(), POS.class);
                }
            }
            ++sceneNum;
        }
    }
}

