/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.drama.main.annotation;

import de.tudarmstadt.ukp.dkpro.core.api.coref.type.CoreferenceChain;
import de.tudarmstadt.ukp.dkpro.core.api.coref.type.CoreferenceLink;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.xml.sax.SAXException;

public class MergeAnnotations
extends JCasAnnotator_ImplBase {
    public static final String PARAM_SOURCE_LOCATION = "Source Location";
    @ConfigurationParameter(name="Source Location")
    String sourceFilename;

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        JCas importJcas;
        try {
            importJcas = JCasFactory.createJCas();
            XmiCasDeserializer.deserialize((InputStream)new FileInputStream(new File(this.sourceFilename)), (CAS)importJcas.getCas(), (boolean)true);
        }
        catch (IOException | SAXException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (UIMAException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        for (CoreferenceChain chain : JCasUtil.select((JCas)importJcas, CoreferenceChain.class)) {
            CoreferenceChain newChain = new CoreferenceChain(jcas);
            newChain.addToIndexes();
            CoreferenceLink newCurrent = null;
            for (CoreferenceLink oldCurrent = chain.getFirst(); oldCurrent != null; oldCurrent = oldCurrent.getNext()) {
                CoreferenceLink newLink = (CoreferenceLink)AnnotationFactory.createAnnotation((JCas)jcas, (int)oldCurrent.getBegin(), (int)oldCurrent.getEnd(), CoreferenceLink.class);
                if (newChain.getFirst() == null) {
                    newChain.setFirst(newLink);
                }
                if (newCurrent != null) {
                    newCurrent.setNext(newLink);
                }
                newCurrent = newLink;
            }
        }
    }
}

