/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.drama.main;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import de.tudarmstadt.ukp.dkpro.core.io.xmi.XmiWriter;
import de.tudarmstadt.ukp.dkpro.core.matetools.MateLemmatizer;
import de.tudarmstadt.ukp.dkpro.core.stanfordnlp.StanfordNamedEntityRecognizer;
import de.tudarmstadt.ukp.dkpro.core.stanfordnlp.StanfordPosTagger;
import de.tudarmstadt.ukp.dkpro.core.tokit.BreakIteratorSegmenter;
import de.unistuttgart.ims.drama.core.ml.gender.ClearTkGenderAnnotator;
import de.unistuttgart.ims.drama.main.Options;
import de.unistuttgart.ims.drama.main.XmlCleanup;
import de.unistuttgart.ims.uimautil.SetCollectionId;
import de.unistuttgart.quadrama.core.D;
import de.unistuttgart.quadrama.core.FigureDetailsAnnotator;
import de.unistuttgart.quadrama.core.FigureMentionDetection;
import de.unistuttgart.quadrama.core.FigureReferenceAnnotator;
import de.unistuttgart.quadrama.core.ReadDlinaMetadata;
import de.unistuttgart.quadrama.core.SceneActAnnotator;
import de.unistuttgart.quadrama.core.SetReferenceDate;
import de.unistuttgart.quadrama.core.SpeakerIdentifier;
import de.unistuttgart.quadrama.io.core.AbstractDramaUrlReader;
import de.unistuttgart.quadrama.io.core.ExportAsCSV;
import de.unistuttgart.quadrama.io.tei.CoreTeiReader;
import de.unistuttgart.quadrama.io.tei.GerDraCorReader;
import de.unistuttgart.quadrama.io.tei.MapFiguresToCastFigures;
import de.unistuttgart.quadrama.io.tei.TextgridTEIUrlReader;
import de.unistuttgart.quadrama.io.tei.TheatreClassiqueReader;
import de.unistuttgart.quadrama.io.tei.TurmReader;
import java.io.File;
import java.io.FilenameFilter;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.resource.ResourceInitializationException;

public class TEI2XMI {
    public static void main(String[] args) throws Exception {
        MyOptions options = (MyOptions)CliFactory.parseArguments(MyOptions.class, (String[])args);
        CollectionReaderDescription reader = TEI2XMI.getReader(options);
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(D.getWrappedSegmenterDescription(BreakIteratorSegmenter.class), new String[0]);
        if (options.getCorpus() == Corpus.TURM) {
            builder.add(AnalysisEngineFactory.createEngineDescription(SceneActAnnotator.class, (Object[])new Object[0]), new String[0]);
        }
        builder.add(AnalysisEngineFactory.createEngineDescription(FigureReferenceAnnotator.class, (Object[])new Object[0]), new String[0]);
        if (options.getCollectionId() != null) {
            builder.add(AnalysisEngineFactory.createEngineDescription(SetCollectionId.class, (Object[])new Object[]{"Collection Id", options.getCollectionId()}), new String[0]);
        }
        builder.add(AnalysisEngineFactory.createEngineDescription(FigureDetailsAnnotator.class, (Object[])new Object[0]), new String[0]);
        if (!options.isSkipSpeakerIdentifier()) {
            builder.add(AnalysisEngineFactory.createEngineDescription(SpeakerIdentifier.class, (Object[])new Object[]{"Create speaker figure", true}), new String[0]);
            builder.add(AnalysisEngineFactory.createEngineDescription(MapFiguresToCastFigures.class, (Object[])new Object[0]), new String[0]);
        }
        if (options.getDlinaDirectory() != null) {
            builder.add(AnalysisEngineFactory.createEngineDescription(ReadDlinaMetadata.class, (Object[])new Object[]{"Dlina Directory", options.getDlinaDirectory()}), new String[0]);
            builder.add(AnalysisEngineFactory.createEngineDescription(SetReferenceDate.class, (Object[])new Object[0]), new String[0]);
        }
        if (options.getGenderModel() != null) {
            builder.add(ClearTkGenderAnnotator.getEngineDescription((String)options.getGenderModel().getAbsolutePath()), new String[0]);
        }
        builder.add(AnalysisEngineFactory.createEngineDescription(StanfordPosTagger.class, (Object[])new Object[0]), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(MateLemmatizer.class, (Object[])new Object[0]), new String[0]);
        if (!options.isSkipNER()) {
            builder.add(AnalysisEngineFactory.createEngineDescription(StanfordNamedEntityRecognizer.class, (Object[])new Object[0]), new String[0]);
        }
        builder.add(AnalysisEngineFactory.createEngineDescription(FigureMentionDetection.class, (Object[])new Object[0]), new String[0]);
        builder.add(SceneActAnnotator.getDescription(), new String[0]);
        if (options.getOutput() != null) {
            builder.add(AnalysisEngineFactory.createEngineDescription(XmiWriter.class, (Object[])new Object[]{"targetLocation", options.getOutput()}), new String[0]);
        }
        if (options.getCSVOutput() != null) {
            builder.add(AnalysisEngineFactory.createEngineDescription(ExportAsCSV.class, (Object[])new Object[]{"targetLocation", options.getCSVOutput(), "CSV Variant Name", "UtterancesWithTokens"}), new String[0]);
            builder.add(AnalysisEngineFactory.createEngineDescription(ExportAsCSV.class, (Object[])new Object[]{"targetLocation", options.getCSVOutput(), "CSV Variant Name", "Segments"}), new String[0]);
            builder.add(AnalysisEngineFactory.createEngineDescription(ExportAsCSV.class, (Object[])new Object[]{"targetLocation", options.getCSVOutput(), "CSV Variant Name", "Metadata"}), new String[0]);
            builder.add(AnalysisEngineFactory.createEngineDescription(ExportAsCSV.class, (Object[])new Object[]{"targetLocation", options.getCSVOutput(), "CSV Variant Name", "Characters"}), new String[0]);
        }
        SimplePipeline.runPipeline((CollectionReaderDescription)reader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{builder.createAggregateDescription()});
        if (options.isDoCleanup()) {
            for (File f : options.getOutput().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("xmi");
                }
            })) {
                XmlCleanup.cleanUp(f);
            }
        }
    }

    public static Class<? extends AbstractDramaUrlReader> getReaderClass(String readerClassname) {
        Class<?> cl;
        try {
            cl = Class.forName(readerClassname);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return TextgridTEIUrlReader.class;
        }
        if (AbstractDramaUrlReader.class.isAssignableFrom(cl)) {
            return cl;
        }
        return TextgridTEIUrlReader.class;
    }

    protected static CollectionReaderDescription getReader(MyOptions options) throws ResourceInitializationException {
        switch (options.getCorpus()) {
            case GERDRACOR: {
                return CollectionReaderFactory.createReaderDescription(GerDraCorReader.class, (Object[])new Object[]{"Input", options.getInput(), "Remove XML Annotations", true, "Language", options.getLanguage()});
            }
            case THEATRECLASSIQUE: {
                return CollectionReaderFactory.createReaderDescription(TheatreClassiqueReader.class, (Object[])new Object[]{"Input", options.getInput(), "Remove XML Annotations", true, "Language", options.getLanguage()});
            }
            case CORETEI: {
                return CollectionReaderFactory.createReaderDescription(CoreTeiReader.class, (Object[])new Object[]{"Input", options.getInput(), "Remove XML Annotations", true, "Language", options.getLanguage()});
            }
            case TURM: {
                return CollectionReaderFactory.createReaderDescription(TurmReader.class, (Object[])new Object[]{"Input", options.getInput(), "Remove XML Annotations", true, "Language", "de"});
            }
        }
        return CollectionReaderFactory.createReaderDescription(TextgridTEIUrlReader.class, (Object[])new Object[]{"Input", options.getInput(), "Remove XML Annotations", true, "strict", true, "Language", options.getLanguage()});
    }

    static interface MyOptions
    extends Options {
        @Option(defaultToNull=true)
        public File getDlinaDirectory();

        @Option(defaultToNull=true)
        public String getCollectionId();

        @Option(defaultToNull=true)
        public File getGenderModel();

        @Option(defaultValue={"true"})
        public boolean isDoCleanup();

        @Deprecated
        @Option(defaultValue={"de.unistuttgart.quadrama.io.tei.textgrid.TextgridTEIUrlReader"})
        public String getReaderClassname();

        @Option(defaultValue={"de"})
        public String getLanguage();

        @Option
        public boolean isSkipNER();

        @Option
        public boolean isSkipSpeakerIdentifier();

        @Option
        public Corpus getCorpus();

        @Option(longName={"csvOutput"}, defaultToNull=true)
        public File getCSVOutput();
    }

    static enum Corpus {
        GERDRACOR,
        TEXTGRID,
        TURM,
        THEATRECLASSIQUE,
        CORETEI;

    }
}

