/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.quadrama.io.tei.textgrid;

import de.unistuttgart.ims.drama.api.Act;
import de.unistuttgart.ims.drama.api.ActHeading;
import de.unistuttgart.ims.drama.api.Author;
import de.unistuttgart.ims.drama.api.Drama;
import de.unistuttgart.ims.drama.api.DramatisPersonae;
import de.unistuttgart.ims.drama.api.Figure;
import de.unistuttgart.ims.drama.api.FigureDescription;
import de.unistuttgart.ims.drama.api.FrontMatter;
import de.unistuttgart.ims.drama.api.MainMatter;
import de.unistuttgart.ims.drama.api.Scene;
import de.unistuttgart.ims.drama.api.SceneHeading;
import de.unistuttgart.ims.drama.api.Speaker;
import de.unistuttgart.ims.drama.api.Speech;
import de.unistuttgart.ims.drama.api.StageDirection;
import de.unistuttgart.ims.drama.api.Utterance;
import de.unistuttgart.ims.uimautil.AnnotationUtil;
import de.unistuttgart.quadrama.io.core.DramaIOUtil;
import de.unistuttgart.quadrama.io.core.Visitor;
import de.unistuttgart.quadrama.io.core.type.HTMLAnnotation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeVisitor;

public class TextGridUtil {
    public static void getNext(JCas jcas, InputStream file, Drama drama, boolean strict) throws IOException, CollectionException {
        Document doc = Jsoup.parse((InputStream)file, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
        drama.setDocumentTitle(doc.select("titleStmt > title").first().text());
        if (!doc.select("idno[type=\"TextGridUri\"]").isEmpty()) {
            drama.setDocumentId(doc.select("idno[type=\"TextGridUri\"]").first().text().substring(9));
        }
        Elements authorElements = doc.select("author");
        for (int i = 0; i < authorElements.size(); ++i) {
            Element authorElement = (Element)authorElements.get(i);
            Author author = new Author(jcas);
            author.setBegin(0);
            author.setEnd(1);
            author.setName(authorElement.text());
            if (authorElement.hasAttr("key")) {
                author.setPnd(authorElement.attr("key").replace("pnd:", ""));
            }
            author.addToIndexes();
        }
        Visitor vis = new Visitor(jcas);
        Element root = doc.select("TEI > text").first();
        root.traverse((NodeVisitor)vis);
        jcas = vis.getJCas();
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, (Map)vis.getAnnotationMap(), (String)"front", FrontMatter.class, null);
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, (Map)vis.getAnnotationMap(), (String)"body", MainMatter.class, null);
        MainMatter mainMatter = (MainMatter)JCasUtil.selectSingle((JCas)jcas, MainMatter.class);
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, (Map)vis.getAnnotationMap(), (String)"speaker", Speaker.class, null);
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, (Map)vis.getAnnotationMap(), (String)"stage", StageDirection.class, (Annotation)mainMatter);
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, (Map)vis.getAnnotationMap(), (String)"sp", Utterance.class, null);
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, (Map)vis.getAnnotationMap(), (String)"l", Speech.class, (Annotation)mainMatter);
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, (Map)vis.getAnnotationMap(), (String)"ab", Speech.class, (Annotation)mainMatter);
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, (Map)vis.getAnnotationMap(), (String)"p", Speech.class, (Annotation)mainMatter);
        TextGridUtil.readActsAndScenes(jcas, root, vis.getAnnotationMap(), strict);
        TextGridUtil.readDramatisPersonae(jcas, root, vis.getAnnotationMap());
        TextGridUtil.fixSpeakerAnnotations(jcas);
        AnnotationUtil.trim(new ArrayList(JCasUtil.select((JCas)jcas, Figure.class)));
        AnnotationUtil.trim(new ArrayList(JCasUtil.select((JCas)jcas, Speech.class)));
        AnnotationUtil.trim(new ArrayList(JCasUtil.select((JCas)jcas, Utterance.class)));
        AnnotationUtil.trim(new ArrayList(JCasUtil.select((JCas)jcas, Scene.class)));
        AnnotationUtil.trim(new ArrayList(JCasUtil.select((JCas)jcas, Act.class)));
    }

    public static void readActs(JCas jcas, Element root, Map<String, HTMLAnnotation> map, boolean strict) {
        if (!root.select("div[type=act]").isEmpty()) {
            DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"div[type=act]", Act.class, null);
            DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"div[type=act] > div > desc > title", ActHeading.class, null);
            DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"div[type=act] > div > head", ActHeading.class, null);
        }
        if (!strict && !JCasUtil.exists((JCas)jcas, Act.class)) {
            DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"body > div", Act.class, null);
            DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"body > div > head", ActHeading.class, null);
            DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"body > div > desc > title", ActHeading.class, null);
        }
    }

    public static void readScenes(JCas jcas, Element root, Map<String, HTMLAnnotation> map, boolean strict) {
        if (!root.select("div[type=scene]").isEmpty()) {
            DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"div[type=scene]", Scene.class, null);
            DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"div[type=scene] > div > desc > title", SceneHeading.class, null);
        } else if (!strict) {
            if (JCasUtil.exists((JCas)jcas, Act.class)) {
                for (Act act : JCasUtil.select((JCas)jcas, Act.class)) {
                    Collection scenes = DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"body > div > div:has(head)", Scene.class, (Annotation)act);
                    for (Scene sc : scenes) {
                        DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"div > desc > title", SceneHeading.class, (Annotation)sc);
                    }
                }
            } else {
                DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"body > div > div:not(:has(desc > title))", Scene.class, null);
                DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"body > div > div > head", SceneHeading.class, null);
                DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"body > div > div > desc > title", SceneHeading.class, null);
            }
        }
    }

    public static void readActsAndScenes(JCas jcas, Element root, Map<String, HTMLAnnotation> map, boolean strict) {
        TextGridUtil.readActs(jcas, root, map, strict);
        TextGridUtil.readScenes(jcas, root, map, strict);
    }

    public static void readDramatisPersonae(JCas jcas, Element root, Map<String, HTMLAnnotation> map) {
        if (!root.select("castList").isEmpty()) {
            DramatisPersonae dp = (DramatisPersonae)DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"castList", DramatisPersonae.class, null).iterator().next();
            Element castList = root.select("castList").first();
            if (!castList.select("castItem role").isEmpty()) {
                DramaIOUtil.select2Annotation((JCas)jcas, (Element)castList, map, (String)"castItem role", Figure.class, (Annotation)dp);
                Collection figDescs = DramaIOUtil.select2Annotation((JCas)jcas, (Element)castList, map, (String)"castItem roleDesc", FigureDescription.class, (Annotation)dp);
                for (FigureDescription figureDescription : figDescs) {
                    Figure fig = (Figure)JCasUtil.selectPreceding(Figure.class, (AnnotationFS)figureDescription, (int)1).get(0);
                    fig.setDescription(figureDescription);
                }
            } else {
                DramaIOUtil.select2Annotation((JCas)jcas, (Element)castList, map, (String)"castItem", Figure.class, null);
            }
        } else {
            try {
                DramatisPersonae dp = (DramatisPersonae)DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"div[type=front] > div:has(p)", DramatisPersonae.class, null).iterator().next();
                AnnotationUtil.trim((Collection)DramaIOUtil.select2Annotation((JCas)jcas, (Element)root, map, (String)"p", Figure.class, (Annotation)dp));
            }
            catch (NoSuchElementException e) {
                System.err.println("No dramatis personae annotation in drama " + Drama.get((JCas)jcas).getDocumentId());
            }
        }
    }

    public static void fixFigureAnnotations(JCas jcas) {
        for (Figure figure : new HashSet(JCasUtil.select((JCas)jcas, Figure.class))) {
            String s = figure.getCoveredText();
            if (!s.contains(",")) continue;
            int oldEnd = figure.getEnd();
            int i = s.indexOf(44);
            figure.setEnd(figure.getBegin() + i);
            FigureDescription fd = (FigureDescription)AnnotationUtil.trim((Annotation)AnnotationFactory.createAnnotation((JCas)jcas, (int)(figure.getEnd() + 1), (int)oldEnd, FigureDescription.class));
            figure.setDescription(fd);
        }
    }

    public static void fixSpeakerAnnotations(JCas jcas) {
        for (Speaker speaker : new HashSet(JCasUtil.select((JCas)jcas, Speaker.class))) {
            AnnotationUtil.trim((Annotation)speaker, (char[])new char[]{'.', ' ', '\t', '\n', '\r', '\f'});
        }
    }
}

