/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.quadrama.io.tei.folger;

import de.unistuttgart.ims.drama.api.Drama;
import de.unistuttgart.ims.uima.io.xml.Visitor;
import de.unistuttgart.ims.uima.io.xml.type.XMLElement;
import de.unistuttgart.quadrama.io.core.AbstractDramaUrlReader;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.util.Level;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Parser;
import org.jsoup.select.NodeVisitor;

public class FolgerReader
extends AbstractDramaUrlReader {
    public void getNext(JCas jcas, InputStream file, Drama drama) throws IOException, CollectionException {
        this.getLogger().log(Level.INFO, "Now parsing XML document");
        Document doc = Jsoup.parse((InputStream)file, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
        FolgerVisitor vis = new FolgerVisitor(jcas);
        Element root = doc.select("TEI > text > body").first();
        this.getLogger().log(Level.INFO, "Traversing XML nodes");
        root.traverse((NodeVisitor)vis);
        jcas = vis.getJCas();
        this.getLogger().log(Level.INFO, "Finished Traversing");
    }

    public class FolgerVisitor
    extends Visitor {
        public FolgerVisitor(JCas jcas) {
            super(jcas);
        }

        public void head(Node node, int depth) {
            if (node.getClass().equals(TextNode.class)) {
                this.builder.add(((TextNode)node).text());
            }
        }

        public void tail(Node node, int depth) {
            if (node.getClass().equals(Element.class)) {
                Element elm = (Element)node;
                XMLElement anno = (XMLElement)this.builder.add(((Integer)this.beginMap.get(node)).intValue(), XMLElement.class);
                anno.setTag(elm.tagName());
                anno.setId(elm.id());
                if (elm.className().isEmpty()) {
                    anno.setCls(elm.attr("type"));
                } else {
                    anno.setCls(elm.className());
                }
                this.annotationMap.put(elm.cssSelector(), anno);
                if (elm.isBlock() || ArrayUtils.contains((Object[])this.blockElements, (Object)elm.tagName())) {
                    this.builder.add("\n");
                }
            }
        }
    }
}

