/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.quadrama.io.gutenbergde;

import de.unistuttgart.ims.drama.api.Act;
import de.unistuttgart.ims.drama.api.ActHeading;
import de.unistuttgart.ims.drama.api.Drama;
import de.unistuttgart.ims.drama.api.DramatisPersonae;
import de.unistuttgart.ims.drama.api.Figure;
import de.unistuttgart.ims.drama.api.Footnote;
import de.unistuttgart.ims.drama.api.FrontMatter;
import de.unistuttgart.ims.drama.api.MainMatter;
import de.unistuttgart.ims.drama.api.Scene;
import de.unistuttgart.ims.drama.api.SceneHeading;
import de.unistuttgart.ims.drama.api.Speaker;
import de.unistuttgart.ims.drama.api.Speech;
import de.unistuttgart.ims.drama.api.StageDirection;
import de.unistuttgart.ims.drama.api.Utterance;
import de.unistuttgart.ims.uimautil.AnnotationUtil;
import de.unistuttgart.quadrama.io.core.AbstractDramaUrlReader;
import de.unistuttgart.quadrama.io.core.DramaIOUtil;
import de.unistuttgart.quadrama.io.core.Visitor;
import de.unistuttgart.quadrama.io.core.type.HTMLAnnotation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeVisitor;

public class GutenbergDEReader
extends AbstractDramaUrlReader {
    public void getNext(JCas jcas, InputStream file, Drama drama) throws IOException, CollectionException {
        String str = IOUtils.toString((InputStream)file);
        Document doc = Jsoup.parseBodyFragment((String)str);
        Visitor vis = new Visitor(jcas);
        doc.traverse((NodeVisitor)vis);
        jcas = vis.getJCas();
        Map annoMap = vis.getAnnotationMap();
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)doc, (Map)annoMap, (String)"div.gutenb:eq(0)", FrontMatter.class, null);
        DramaIOUtil.selectRange2Annotation((JCas)jcas, (Element)doc, (Map)annoMap, (String)"div.gutenb:eq(1)", (String)"div.gutenb:last-child", MainMatter.class);
        FrontMatter frontMatter = (FrontMatter)JCasUtil.selectSingle((JCas)jcas, FrontMatter.class);
        MainMatter mainMatter = (MainMatter)JCasUtil.selectSingle((JCas)jcas, MainMatter.class);
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)doc, (Map)annoMap, (String)"span.speaker", Speaker.class, (Annotation)mainMatter);
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)doc, (Map)annoMap, (String)"span.speaker", Figure.class, (Annotation)frontMatter);
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)doc, (Map)annoMap, (String)"span.regie", StageDirection.class, (Annotation)mainMatter);
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)doc, (Map)annoMap, (String)"span.footnote", Footnote.class, (Annotation)mainMatter);
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)doc, (Map)annoMap, (String)"h3 + p", DramatisPersonae.class, (Annotation)frontMatter);
        DramaIOUtil.select2Annotation((JCas)jcas, (Element)doc, (Map)annoMap, (String)"p:has(span.speaker)", Utterance.class, (Annotation)mainMatter);
        Elements elms = doc.select("p.leftmarg");
        for (Element elm : elms) {
            HTMLAnnotation hAnno = (HTMLAnnotation)annoMap.get(elm.cssSelector());
            Utterance utterance = (Utterance)JCasUtil.selectPreceding(Utterance.class, (AnnotationFS)hAnno, (int)1).get(0);
            utterance.setEnd(hAnno.getEnd());
        }
        this.annotateSpeech(jcas, (Annotation)mainMatter);
        int currentSceneBegin = -1;
        int currentActBegin = -1;
        for (HTMLAnnotation anno : JCasUtil.select((JCas)jcas, HTMLAnnotation.class)) {
            if (anno.getTag().equals("h2") && !anno.getCls().contains("author")) {
                AnnotationFactory.createAnnotation((JCas)jcas, (int)anno.getBegin(), (int)anno.getEnd(), SceneHeading.class);
                if (currentSceneBegin >= 0) {
                    AnnotationFactory.createAnnotation((JCas)jcas, (int)currentSceneBegin, (int)(anno.getBegin() - 1), Scene.class);
                }
                currentSceneBegin = anno.getBegin();
            }
            if (!anno.getTag().equals("h1") || anno.getCls().contains("title")) continue;
            AnnotationFactory.createAnnotation((JCas)jcas, (int)anno.getBegin(), (int)anno.getEnd(), ActHeading.class);
            if (currentActBegin >= 0) {
                AnnotationFactory.createAnnotation((JCas)jcas, (int)currentActBegin, (int)(anno.getBegin() - 1), Act.class);
                if (currentSceneBegin >= 0) {
                    AnnotationFactory.createAnnotation((JCas)jcas, (int)currentSceneBegin, (int)(anno.getBegin() - 1), Scene.class);
                    currentSceneBegin = -1;
                }
            }
            currentActBegin = anno.getBegin();
        }
        if (currentActBegin >= 0) {
            AnnotationFactory.createAnnotation((JCas)jcas, (int)currentActBegin, (int)mainMatter.getEnd(), Act.class);
        }
        if (currentSceneBegin >= 0) {
            AnnotationFactory.createAnnotation((JCas)jcas, (int)currentSceneBegin, (int)mainMatter.getEnd(), Scene.class);
        }
        AnnotationUtil.trim(new ArrayList(JCasUtil.select((JCas)jcas, Scene.class)));
        AnnotationUtil.trim(new ArrayList(JCasUtil.select((JCas)jcas, Act.class)));
        DramaIOUtil.cleanUp((JCas)jcas);
    }

    protected void annotateSpeech(JCas jcas, Annotation mainMatter) {
        for (Utterance utterance : JCasUtil.selectCovered(Utterance.class, (AnnotationFS)mainMatter)) {
            TreeSet<Annotation> except = new TreeSet<Annotation>(new Comparator<Annotation>(){

                @Override
                public int compare(Annotation o1, Annotation o2) {
                    return Integer.compare(o1.getBegin(), o2.getBegin());
                }
            });
            except.addAll(JCasUtil.selectCovered(StageDirection.class, (AnnotationFS)utterance));
            except.addAll(JCasUtil.selectCovered(Speaker.class, (AnnotationFS)utterance));
            except.addAll(JCasUtil.selectCovered(Footnote.class, (AnnotationFS)utterance));
            int b = utterance.getBegin();
            for (Annotation exc : except) {
                if (exc.getBegin() > b) {
                    AnnotationUtil.trim((Annotation)AnnotationFactory.createAnnotation((JCas)jcas, (int)b, (int)exc.getBegin(), Speech.class));
                }
                b = exc.getEnd();
            }
            if (b >= utterance.getEnd()) continue;
            AnnotationUtil.trim((Annotation)AnnotationFactory.createAnnotation((JCas)jcas, (int)b, (int)utterance.getEnd(), Speech.class));
        }
        for (Speech speech : new ArrayList(JCasUtil.select((JCas)jcas, Speech.class))) {
            if (speech.getCoveredText().matches("^\\s*$")) {
                speech.removeFromIndexes();
                continue;
            }
            try {
                AnnotationUtil.trimBegin((Annotation)speech, (char[])new char[]{'.', ' '});
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
    }

    protected void assignSpeakerIds(JCas jcas) {
        DramatisPersonae dp = (DramatisPersonae)JCasUtil.selectSingle((JCas)jcas, DramatisPersonae.class);
        int speakerId = 1;
        HashMap<String, Speaker> speakerMap = new HashMap<String, Speaker>();
        for (Speaker speaker : JCasUtil.selectCovered(Speaker.class, (AnnotationFS)dp)) {
            speaker.setId(speakerId++);
            speakerMap.put(speaker.getCoveredText(), speaker);
        }
        for (Speaker speaker : JCasUtil.select((JCas)jcas, Speaker.class)) {
            if (speaker.getId() != 0) continue;
            try {
                speaker.setId(((Speaker)speakerMap.get(speaker.getCoveredText())).getId());
            }
            catch (NullPointerException nullPointerException) {}
        }
    }
}

