/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.quadrama.io.core;

import de.unistuttgart.quadrama.io.core.type.HTMLAnnotation;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.uima.fit.factory.JCasBuilder;
import org.apache.uima.jcas.JCas;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeVisitor;

public class Visitor
implements NodeVisitor {
    protected JCasBuilder builder;
    protected Map<Node, Integer> beginMap = new HashMap<Node, Integer>();
    protected Map<String, HTMLAnnotation> annotationMap = new HashMap<String, HTMLAnnotation>();
    protected String[] blockElements = new String[]{"l", "p", "sp"};

    public Visitor(JCas jcas) {
        this.builder = new JCasBuilder(jcas);
    }

    public void head(Node node, int depth) {
        if (node.getClass().equals(TextNode.class)) {
            this.builder.add(((TextNode)node).text());
        } else {
            this.beginMap.put(node, this.builder.getPosition());
        }
    }

    public void tail(Node node, int depth) {
        if (node.getClass().equals(Element.class)) {
            Element elm = (Element)node;
            HTMLAnnotation anno = (HTMLAnnotation)((Object)this.builder.add(this.beginMap.get(node).intValue(), HTMLAnnotation.class));
            anno.setTag(elm.tagName());
            anno.setId(elm.id());
            anno.setSelector(elm.cssSelector());
            if (elm.className().isEmpty()) {
                anno.setCls(elm.attr("type"));
            } else {
                anno.setCls(elm.className());
            }
            this.annotationMap.put(elm.cssSelector(), anno);
            if (elm.isBlock() || ArrayUtils.contains((Object[])this.blockElements, (Object)elm.tagName())) {
                this.builder.add("\n");
            }
        }
    }

    public JCas getJCas() {
        this.builder.close();
        return this.builder.getJCas();
    }

    public Map<String, HTMLAnnotation> getAnnotationMap() {
        return this.annotationMap;
    }
}

