/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.quadrama.io.core;

import de.unistuttgart.ims.drama.api.Figure;
import de.unistuttgart.ims.drama.api.Speaker;
import de.unistuttgart.ims.drama.api.Speech;
import de.unistuttgart.ims.drama.api.Utterance;
import de.unistuttgart.ims.drama.util.DramaUtil;
import de.unistuttgart.quadrama.io.core.AbstractExtractSpeechConsumer;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class ExtractSpeechByFigure
extends AbstractExtractSpeechConsumer {
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        File file = new File(this.outputDirectory, DramaUtil.getDisplayId((JCas)jcas));
        file.mkdir();
        HashMap<String, FileWriter> writerMap = new HashMap<String, FileWriter>();
        try {
            for (Figure figure : JCasUtil.select((JCas)jcas, Figure.class)) {
                writerMap.put(figure.getReference(), new FileWriter(new File(file, figure.getCoveredText() + ".txt")));
            }
            for (Utterance utterance : JCasUtil.select((JCas)jcas, Utterance.class)) {
                try {
                    Speaker speaker = (Speaker)JCasUtil.selectCovered(Speaker.class, (AnnotationFS)utterance).get(0);
                    if (speaker.getFigure() == null) continue;
                    List speeches = JCasUtil.selectCovered(Speech.class, (AnnotationFS)utterance);
                    String writerIndex = speaker.getFigure().getReference();
                    for (Speech speech : speeches) {
                        if (!writerMap.containsKey(writerIndex)) continue;
                        ((Writer)writerMap.get(writerIndex)).write(speech.getCoveredText());
                        ((Writer)writerMap.get(writerIndex)).write(" ");
                    }
                    if (!writerMap.containsKey(writerIndex)) continue;
                    ((Writer)writerMap.get(writerIndex)).write("\n");
                }
                catch (IndexOutOfBoundsException e) {}
            }
            for (Writer writer : writerMap.values()) {
                writer.flush();
                writer.close();
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        finally {
            for (Writer writer : writerMap.values()) {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }
}

