/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.quadrama.io.core;

import de.unistuttgart.ims.drama.api.Drama;
import de.unistuttgart.quadrama.io.core.DramaIOUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Progress;

public abstract class AbstractDramaUrlReader
extends JCasCollectionReader_ImplBase {
    public static final String PARAM_URL_LIST = "URL List";
    public static final String PARAM_INPUT_DIRECTORY = "Input Directory";
    public static final String PARAM_LANGUAGE = "Language";
    public static final String PARAM_CLEANUP = "Cleanup";
    @ConfigurationParameter(name="Input Directory", mandatory=false)
    String inputDirectory = null;
    @ConfigurationParameter(name="URL List", mandatory=false)
    String urlListFilename = null;
    @ConfigurationParameter(name="Language", mandatory=false, defaultValue={"de"})
    String language = "de";
    @ConfigurationParameter(name="Cleanup", mandatory=false)
    boolean cleanUp = false;
    List<URL> urls = new LinkedList<URL>();
    int currentUrlIndex = 0;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        block12: {
            block11: {
                super.initialize(context);
                if (this.urlListFilename == null) break block11;
                CSVParser r = null;
                try {
                    r = new CSVParser((Reader)new FileReader(new File(this.urlListFilename)), CSVFormat.TDF);
                    List records = r.getRecords();
                    for (CSVRecord rec : records) {
                        String s = rec.get(0);
                        if (s.startsWith("/")) {
                            this.urls.add(new File(s).toURI().toURL());
                            continue;
                        }
                        this.urls.add(new URL(s));
                    }
                    this.getLogger().log(Level.FINE, "Found " + this.urls.size() + " URLs.");
                }
                catch (Exception e) {
                    try {
                        throw new ResourceInitializationException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(r);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)r);
                break block12;
            }
            if (this.inputDirectory != null) {
                File inputDir = new File(this.inputDirectory);
                File[] files = inputDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".xml");
                    }
                });
                try {
                    for (File file : files) {
                        this.urls.add(file.toURI().toURL());
                    }
                }
                catch (Exception e) {
                    throw new ResourceInitializationException((Throwable)e);
                }
            } else {
                throw new ResourceInitializationException("You need to specify either PARAM_INPUT_DIRECTORY or PARAM_URL_LIST", null);
            }
        }
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.currentUrlIndex < this.urls.size();
    }

    public Progress[] getProgress() {
        return null;
    }

    public void getNext(JCas jcas) throws IOException, CollectionException {
        URL url = this.urls.get(this.currentUrlIndex++);
        this.getLogger().debug((Object)("Processing url " + url));
        Drama drama = new Drama(jcas);
        drama.setDocumentId(String.valueOf(this.currentUrlIndex));
        drama.setDocumentUri(url.toString());
        drama.addToIndexes();
        jcas.setDocumentLanguage(this.language);
        this.getNext(jcas, url.openStream(), drama);
        if (this.cleanUp) {
            DramaIOUtil.cleanUp(jcas);
        }
    }

    public abstract void getNext(JCas var1, InputStream var2, Drama var3) throws IOException, CollectionException;
}

