/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.quadrama.io.core;

import de.unistuttgart.ims.drama.api.Figure;
import de.unistuttgart.ims.drama.api.Speaker;
import de.unistuttgart.ims.drama.api.Speech;
import de.unistuttgart.ims.drama.api.Utterance;
import de.unistuttgart.ims.drama.util.DramaUtil;
import de.unistuttgart.quadrama.io.core.AbstractExtractSpeechConsumer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class ExtractSpeechByType
extends AbstractExtractSpeechConsumer {
    public static final String PARAM_TYPE = "Sorting Type";
    public static final String PARAM_MERGED = "Merged";
    @ConfigurationParameter(name="Sorting Type", mandatory=true)
    String sortingType = null;
    @ConfigurationParameter(name="Merged", mandatory=false, defaultValue={"true"})
    boolean merged = true;
    Map<String, Writer> writerMap = new HashMap<String, Writer>();

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        block13: {
            File file = this.outputDirectory;
            try {
                for (Utterance utterance : JCasUtil.select((JCas)jcas, Utterance.class)) {
                    try {
                        Speaker speaker = (Speaker)JCasUtil.selectCovered(Speaker.class, (AnnotationFS)utterance).get(0);
                        if (speaker.getFigure() == null) continue;
                        List speeches = JCasUtil.selectCovered(Speech.class, (AnnotationFS)utterance);
                        String writerIndex = DramaUtil.getTypeValue((JCas)jcas, (Figure)speaker.getFigure(), (String)this.sortingType);
                        if (writerIndex == null) continue;
                        if (!this.merged) {
                            writerIndex = DramaUtil.getDisplayId((JCas)jcas) + "_" + writerIndex;
                        }
                        for (Speech speech : speeches) {
                            this.getWriter(file, writerIndex).write(speech.getCoveredText());
                            this.getWriter(file, writerIndex).write(" ");
                        }
                        this.getWriter(file, writerIndex).write("\n");
                    }
                    catch (IndexOutOfBoundsException e) {}
                }
                if (!this.merged) {
                    this.closeWriters();
                }
                if (this.merged) break block13;
            }
            catch (Exception e) {
                try {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (!this.merged) {
                        for (Writer writer : this.writerMap.values()) {
                            IOUtils.closeQuietly((Writer)writer);
                        }
                    }
                    throw throwable;
                }
            }
            for (Writer writer : this.writerMap.values()) {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        if (this.merged) {
            this.closeWriters();
        }
    }

    protected void closeWriters() {
        for (Writer w : this.writerMap.values()) {
            try {
                w.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IOUtils.closeQuietly((Writer)w);
        }
        this.writerMap.clear();
    }

    protected Writer getWriter(File file, String value) throws IOException {
        if (!this.writerMap.containsKey(value)) {
            this.writerMap.put(value, new FileWriter(new File(file, value + ".txt")));
        }
        return this.writerMap.get(value);
    }
}

