/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.quadrama.io.core;

import de.unistuttgart.quadrama.io.core.type.HTMLAnnotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class DramaIOUtil {
    public static void cleanUp(JCas jcas) {
        jcas.removeAllIncludingSubtypes(HTMLAnnotation.type);
    }

    public static <T extends Annotation> Collection<T> select2Annotation(JCas jcas, Element rootElement, Map<String, HTMLAnnotation> annoMap, String cssSelector, Class<T> annoClass, Annotation coveringAnnotation) {
        HashSet<Annotation> set = new HashSet<Annotation>();
        Elements elms = rootElement.select(cssSelector);
        for (Element elm : elms) {
            HTMLAnnotation hAnno = annoMap.get(elm.cssSelector());
            if (!elm.hasText() && elm.childNodeSize() <= 0 || coveringAnnotation != null && (coveringAnnotation.getBegin() > hAnno.getBegin() || coveringAnnotation.getEnd() < hAnno.getEnd())) continue;
            set.add(AnnotationFactory.createAnnotation((JCas)jcas, (int)hAnno.getBegin(), (int)hAnno.getEnd(), annoClass));
        }
        return set;
    }

    public static <T extends Annotation> T selectRange2Annotation(JCas jcas, Element rootElement, Map<String, HTMLAnnotation> annoMap, String beginCssSelector, String endCssSelector, Class<T> annoClass) {
        Elements elms = rootElement.select(beginCssSelector);
        int begin = jcas.size();
        for (Element elm : elms) {
            HTMLAnnotation hAnno = annoMap.get(elm.cssSelector());
            if (hAnno.getBegin() >= begin) continue;
            begin = hAnno.getBegin();
        }
        elms = rootElement.select(endCssSelector);
        int end = 0;
        for (Element elm : elms) {
            HTMLAnnotation hAnno = annoMap.get(elm.cssSelector());
            if (hAnno.getEnd() <= end) continue;
            end = hAnno.getEnd();
        }
        return (T)AnnotationFactory.createAnnotation((JCas)jcas, (int)begin, (int)end, annoClass);
    }
}

