/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.quadrama.graph.ext;

import de.unistuttgart.ims.drama.api.Figure;
import de.unistuttgart.quadrama.graph.ext.api.GraphMetaData;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.jgrapht.Graph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.graph.DefaultWeightedEdge;

public class GraphImporter {
    public static Graph<Figure, DefaultWeightedEdge> getGraph(JCas jcas, String viewName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, CASException {
        JCas graphView = jcas.getView(viewName);
        HashMap<Integer, Figure> figureMap = new HashMap<Integer, Figure>();
        for (Figure figure : JCasUtil.select((JCas)jcas, Figure.class)) {
            figureMap.put(figure.getBegin(), figure);
        }
        if (!JCasUtil.exists((JCas)graphView, GraphMetaData.class)) {
            return null;
        }
        GraphMetaData gmd = (GraphMetaData)JCasUtil.selectSingle((JCas)graphView, GraphMetaData.class);
        Class<?> cl = Class.forName(gmd.getGraphClassName());
        Graph graph = (Graph)cl.getConstructor(Class.class).newInstance(DefaultWeightedEdge.class);
        boolean weighted = false;
        if (graph instanceof WeightedGraph) {
            weighted = true;
        }
        Pattern pattern = weighted ? Pattern.compile("(-?\\d+) (-?\\d+) (\\d+.\\d+)") : Pattern.compile("(-?\\d+) (-?\\d+)");
        for (String line : graphView.getDocumentText().split("\n")) {
            Matcher m = pattern.matcher(line);
            if (!m.find()) continue;
            int sId = Integer.valueOf(m.group(1));
            int tId = Integer.valueOf(m.group(2));
            Figure sFigure = (Figure)figureMap.get(sId);
            Figure tFigure = (Figure)figureMap.get(tId);
            if (!graph.containsVertex((Object)sFigure)) {
                graph.addVertex((Object)sFigure);
            }
            if (!graph.containsVertex((Object)tFigure)) {
                graph.addVertex((Object)tFigure);
            }
            Object edge = graph.addEdge((Object)sFigure, (Object)tFigure);
            if (!weighted) continue;
            double w = Double.valueOf(m.group(3));
            if (edge == null) continue;
            ((WeightedGraph)graph).setEdgeWeight((Object)((DefaultWeightedEdge)edge), w);
        }
        return graph;
    }
}

