/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.quadrama.graph.ext;

import de.unistuttgart.ims.drama.api.Figure;
import de.unistuttgart.quadrama.graph.ext.api.GraphMetaData;
import java.io.IOException;
import java.io.StringWriter;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.jcas.JCas;
import org.jgrapht.Graph;
import org.jgrapht.WeightedGraph;

public class GraphExporter {
    public void export(JCas jcas, Graph<Figure, ?> graph) throws IOException {
        StringWriter sw = new StringWriter();
        sw.write(" \n");
        for (Figure figure1 : graph.vertexSet()) {
            for (Figure figure2 : graph.vertexSet()) {
                if (!graph.containsEdge((Object)figure1, (Object)figure2)) continue;
                sw.write(figure1.getBegin() + " " + figure2.getBegin());
                Object edge = graph.getEdge((Object)figure1, (Object)figure2);
                try {
                    double w = ((WeightedGraph)graph).getEdgeWeight(edge);
                    sw.write(" " + w);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                sw.write("\n");
            }
        }
        sw.flush();
        sw.close();
        jcas.setDocumentText(sw.toString());
        jcas.setDocumentLanguage("");
        GraphMetaData graphAnnotation = (GraphMetaData)AnnotationFactory.createAnnotation((JCas)jcas, (int)0, (int)1, GraphMetaData.class);
        graphAnnotation.setGraphClassName(graph.getClass().getCanonicalName());
        if (!graph.edgeSet().isEmpty()) {
            graphAnnotation.setEdgeClassName(graph.edgeSet().iterator().next().getClass().getCanonicalName());
        }
    }
}

