/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.quadrama.graph;

import de.unistuttgart.ims.drama.api.Figure;
import de.unistuttgart.ims.drama.api.FigureMention;
import de.unistuttgart.ims.drama.api.MainMatter;
import de.unistuttgart.ims.drama.api.Scene;
import de.unistuttgart.ims.drama.api.Speaker;
import de.unistuttgart.ims.drama.api.Utterance;
import de.unistuttgart.ims.drama.util.DramaUtil;
import de.unistuttgart.quadrama.graph.NetworkType;
import de.unistuttgart.quadrama.graph.ext.GraphExporter;
import java.io.IOException;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.util.Level;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.DirectedPseudograph;
import org.jgrapht.graph.SimpleWeightedGraph;

public class NetworkExtractor
extends JCasAnnotator_ImplBase {
    public static final String PARAM_VIEW_NAME = "View Name";
    public static final String PARAM_NETWORK_TYPE = "Network Type";
    @ConfigurationParameter(name="Network Type", defaultValue={"Copresence"}, mandatory=false)
    NetworkType networkType = NetworkType.Copresence;
    @ConfigurationParameter(name="View Name", mandatory=false)
    String viewName = NetworkType.Copresence.name();

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        DirectedGraph<Figure, DefaultEdge> graph = null;
        switch (this.networkType) {
            case MentionNetwork: {
                graph = this.extractMentionNetwork(jcas);
                break;
            }
            default: {
                graph = this.extractNetwork(jcas, (Annotation)JCasUtil.selectSingle((JCas)jcas, MainMatter.class));
            }
        }
        GraphExporter gmlExporter = new GraphExporter();
        try {
            JCas graphView = jcas.createView(this.viewName);
            this.getLogger().log(Level.INFO, "Exporting graph into " + this.viewName);
            gmlExporter.export(graphView, (Graph<Figure, ?>)graph);
        }
        catch (CASException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected DirectedGraph<Figure, DefaultEdge> extractMentionNetwork(JCas jcas) {
        DirectedPseudograph graph = new DirectedPseudograph(DefaultEdge.class);
        for (Utterance utterance : JCasUtil.select((JCas)jcas, Utterance.class)) {
            Speaker speaker = DramaUtil.getFirstSpeaker((Utterance)utterance);
            if (speaker == null) continue;
            for (FigureMention mention : JCasUtil.selectCovered((JCas)jcas, FigureMention.class, (AnnotationFS)utterance)) {
                if (speaker.getFigure() == null || mention.getFigure() == null) continue;
                if (!graph.containsVertex((Object)speaker.getFigure())) {
                    graph.addVertex((Object)speaker.getFigure());
                }
                if (!graph.containsVertex((Object)mention.getFigure())) {
                    graph.addVertex((Object)mention.getFigure());
                }
                graph.addEdge((Object)speaker.getFigure(), (Object)mention.getFigure());
            }
        }
        return graph;
    }

    protected WeightedGraph<Figure, DefaultWeightedEdge> extractNetwork(JCas jcas, Annotation range) {
        SimpleWeightedGraph graph = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        for (Figure figure : JCasUtil.select((JCas)jcas, Figure.class)) {
            if (graph.containsVertex((Object)figure)) continue;
            graph.addVertex((Object)figure);
        }
        for (Scene scene : JCasUtil.select((JCas)jcas, Scene.class)) {
            List speakers = JCasUtil.selectCovered(Speaker.class, (AnnotationFS)scene);
            for (Speaker s1 : speakers) {
                Figure gf1 = s1.getFigure();
                if (gf1 == null) continue;
                for (Speaker s2 : speakers) {
                    Figure gf2 = s2.getFigure();
                    if (gf2 == null) continue;
                    if (graph.containsEdge((Object)gf1, (Object)gf2)) {
                        DefaultWeightedEdge edge = (DefaultWeightedEdge)graph.getEdge((Object)gf1, (Object)gf2);
                        double w = graph.getEdgeWeight((Object)edge);
                        graph.setEdgeWeight((Object)edge, w + 1.0);
                        continue;
                    }
                    if (gf1 == gf2) continue;
                    graph.addEdge((Object)gf1, (Object)gf2);
                }
            }
        }
        return graph;
    }
}

