/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.drama.core.ml.gender;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import de.tudarmstadt.ukp.dkpro.core.io.xmi.XmiWriter;
import de.tudarmstadt.ukp.dkpro.core.tokit.BreakIteratorSegmenter;
import de.unistuttgart.ims.drama.api.DramatisPersonae;
import de.unistuttgart.ims.drama.api.Figure;
import de.unistuttgart.ims.drama.core.ml.AbstractEvaluation;
import de.unistuttgart.ims.drama.core.ml.ClearTkUtil;
import de.unistuttgart.ims.drama.core.ml.PrepareClearTk;
import de.unistuttgart.ims.drama.core.ml.gender.ClearTkGenderAnnotator;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.ml.jar.Train;
import org.cleartk.ml.libsvm.LibSvmStringOutcomeDataWriter;

public class Evaluation
extends AbstractEvaluation {
    public Evaluation(File baseDirectory) {
        super(ClearTkGenderAnnotator.class, baseDirectory);
    }

    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        List<File> allFiles = Arrays.asList(options.getTrainDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("xmi");
            }
        }));
        Evaluation evaluator = new Evaluation(options.getModelsDirectory());
        List crossValidationStatsList = evaluator.crossValidation(allFiles, 5);
        AnnotationStatistics crossValidationStats = AnnotationStatistics.addAll((Iterable)crossValidationStatsList);
        System.out.println(crossValidationStats);
        System.out.println(ClearTkUtil.toCmdLine(crossValidationStats.confusions()));
    }

    protected void train(CollectionReader collectionReader, File directory) throws Exception {
        String tmpView = "DP";
        AggregateBuilder b = new AggregateBuilder();
        b.add(AnalysisEngineFactory.createEngineDescription(PrepareClearTk.class, (Object[])new Object[]{"View name", tmpView, "Annotation type", DramatisPersonae.class, "Sub annotations", Arrays.asList(Figure.class)}), new String[0]);
        b.add(AnalysisEngineFactory.createEngineDescription(BreakIteratorSegmenter.class, (Object[])new Object[0]), new String[]{"_InitialView", tmpView});
        b.add(AnalysisEngineFactory.createEngineDescription(ClearTkGenderAnnotator.class, (Object[])new Object[]{"dataWriterClassName", LibSvmStringOutcomeDataWriter.class, "outputDirectory", directory}), new String[]{"_InitialView", tmpView});
        b.add(AnalysisEngineFactory.createEngineDescription(XmiWriter.class, (Object[])new Object[]{"targetLocation", "target/xmi"}), new String[0]);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{b.createAggregate()});
        Train.main((File)directory, (String[])new String[]{"-t", "0"});
    }

    protected AnnotationStatistics<String> test(CollectionReader collectionReader, File modelDirectory) throws Exception {
        String silverViewName = "DP";
        String goldViewName = "GoldView";
        AggregateBuilder aggregate = new AggregateBuilder();
        aggregate.add(AnalysisEngineFactory.createEngineDescription(PrepareClearTk.class, (Object[])new Object[]{"View name", "GoldView", "Annotation type", DramatisPersonae.class, "Sub annotations", Arrays.asList(Figure.class)}), new String[0]);
        aggregate.add(AnalysisEngineFactory.createEngineDescription(PrepareClearTk.class, (Object[])new Object[]{"View name", "DP", "Annotation type", DramatisPersonae.class, "Sub annotations", Arrays.asList(Figure.class)}), new String[0]);
        aggregate.add(AnalysisEngineFactory.createEngineDescription(BreakIteratorSegmenter.class, (Object[])new Object[]{"writeSentence", false}), new String[]{"_InitialView", "DP"});
        aggregate.add(AnalysisEngineFactory.createEngineDescription((Class)this.tagger, (Object[])new Object[]{"isTraining", false, "classifierJarPath", JarClassifierBuilder.getModelJarFile((File)modelDirectory)}), new String[]{"_InitialView", "DP"});
        aggregate.add(AnalysisEngineFactory.createEngineDescription(XmiWriter.class, (Object[])new Object[]{"targetLocation", "target/debug/", "useDocumentId", true}), new String[0]);
        AnnotationStatistics stats = new AnnotationStatistics();
        JCasIterator iter = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregate.createAggregate()});
        while (iter.hasNext()) {
            JCas jCas = iter.next();
            JCas goldView = jCas.getView("GoldView");
            JCas systemView = jCas.getView("DP");
            Collection goldMentions = JCasUtil.select((JCas)goldView, Figure.class);
            Collection systemMentions = JCasUtil.select((JCas)systemView, Figure.class);
            stats.add(goldMentions, systemMentions, AnnotationStatistics.annotationToSpan(), AnnotationStatistics.annotationToFeatureValue((String)"Gender"));
        }
        return stats;
    }

    public static interface Options {
        @Option(longName={"train-dir"}, description="Specify the directory containing the training documents.  This is used for cross-validation and for training in a holdout set evaluator. When we run this example we point to a directory containing training data from the MASC-1.0.3 corpus - i.e. a directory called 'MASC-1.0.3/data/written'", defaultValue={"src/main/resources/gender/training"})
        public File getTrainDirectory();

        @Option(longName={"models-dir"}, description="specify the directory in which to write out the trained model files", defaultValue={"target/models"})
        public File getModelsDirectory();
    }
}

