/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.drama.core.ml.gender;

import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Token;
import de.tudarmstadt.ukp.dkpro.core.tokit.BreakIteratorSegmenter;
import de.unistuttgart.ims.cleartkutil.ListFeatureExtractor;
import de.unistuttgart.ims.cleartkutil.SuffixFeatureExtractor;
import de.unistuttgart.ims.drama.api.DramatisPersonae;
import de.unistuttgart.ims.drama.api.Figure;
import de.unistuttgart.ims.drama.api.FigureType;
import de.unistuttgart.ims.drama.core.ml.MapBackFeature;
import de.unistuttgart.ims.drama.core.ml.PrepareClearTk;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.CombinedExtractor1;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class ClearTkGenderAnnotator
extends CleartkAnnotator<String> {
    FeatureExtractor1<Figure> extractor;
    CleartkExtractor.Context contextExtractor;
    FeatureExtractor1<Token> tokenExtractor;
    List<String> maleFirstNames;
    List<String> femaleFirstNames;
    List<String> maleTitles;
    List<String> femaleTitles;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.extractor = new CombinedExtractor1((FeatureExtractor1)new CoveredTextExtractor(), (FeatureExtractor1)new FeatureExtractor1<Figure>(){

            public List<Feature> extract(JCas view, Figure focusAnnotation) throws CleartkExtractorException {
                return Arrays.asList(new Feature("Length", (Object)(focusAnnotation.getEnd() - focusAnnotation.getBegin())));
            }
        });
        try {
            this.maleFirstNames = IOUtils.readLines((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/gender/m.csv"), (String)"UTF-8");
            this.femaleFirstNames = IOUtils.readLines((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/gender/f.csv"), (String)"UTF-8");
            this.maleTitles = IOUtils.readLines((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/gender/m.titles.csv"), (String)"UTF-8");
            this.femaleTitles = IOUtils.readLines((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/gender/f.titles.csv"), (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.contextExtractor = new CleartkExtractor.Covered();
        try {
            this.tokenExtractor = new CombinedExtractor1((FeatureExtractor1)new CoveredTextExtractor(), (FeatureExtractor1)new ListFeatureExtractor("male_first_names", this.maleFirstNames), (FeatureExtractor1)new ListFeatureExtractor("female_first_name", this.femaleFirstNames), (FeatureExtractor1)new ListFeatureExtractor("male_titles", this.maleTitles), (FeatureExtractor1)new ListFeatureExtractor("female_titles", this.femaleTitles), (FeatureExtractor1)new ListFeatureExtractor("numerals", IOUtils.readLines((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/gender/numbers.csv"), (String)"UTF-8")), (FeatureExtractor1)new SuffixFeatureExtractor("in"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        for (Figure figure : JCasUtil.select((JCas)jcas, Figure.class)) {
            List features = this.extractor.extract(jcas, (Annotation)figure);
            features.addAll(this.contextExtractor.extract(jcas, (Annotation)figure, null, Token.class, this.tokenExtractor));
            if (this.isTraining()) {
                String outcome = figure.getGender();
                if (outcome == null) continue;
                this.dataWriter.write(new Instance((Object)outcome, (Collection)features));
                continue;
            }
            String category = (String)this.classifier.classify(features);
            figure.setGender(category);
        }
    }

    public static AnalysisEngineDescription getEngineDescription(String genderModelUrl) throws ResourceInitializationException {
        String tmpView = "tmp:Dramatis Personae";
        AggregateBuilder b = new AggregateBuilder();
        b.add(AnalysisEngineFactory.createEngineDescription(PrepareClearTk.class, (Object[])new Object[]{"View name", tmpView, "Annotation type", DramatisPersonae.class, "Sub annotations", Arrays.asList(Figure.class, FigureType.class)}), new String[0]);
        b.add(AnalysisEngineFactory.createEngineDescription(BreakIteratorSegmenter.class, (Object[])new Object[]{"writeSentence", false}), new String[]{"_InitialView", tmpView});
        b.add(AnalysisEngineFactory.createEngineDescription(ClearTkGenderAnnotator.class, (Object[])new Object[]{"classifierJarPath", genderModelUrl}), new String[]{"_InitialView", tmpView});
        b.add(AnalysisEngineFactory.createEngineDescription(MapBackFeature.class, (Object[])new Object[]{"Annotation type", Figure.class, "View name", tmpView, "Feature name", "Gender"}), new String[0]);
        return b.createAggregateDescription();
    }
}

