/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.drama.core.ml;

import de.unistuttgart.quadrama.core.api.Origin;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.factory.JCasBuilder;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class PrepareClearTk
extends JCasAnnotator_ImplBase {
    public static final String PARAM_VIEW_NAME = "View name";
    public static final String PARAM_ANNOTATION_TYPE = "Annotation type";
    public static final String PARAM_SUBANNOTATIONS = "Sub annotations";
    @ConfigurationParameter(name="View name")
    String viewName;
    @ConfigurationParameter(name="Annotation type")
    String annotationClassName;
    @ConfigurationParameter(name="Sub annotations")
    List<String> subAnnotationClassnames;
    Class<Annotation> annotationClass;
    List<Class<Annotation>> subAnnotations = new LinkedList<Class<Annotation>>();

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            Class<?> cl = Class.forName(this.annotationClassName);
            this.annotationClass = cl;
        }
        catch (ClassNotFoundException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        try {
            for (String className : this.subAnnotationClassnames) {
                Class<?> cl = Class.forName(className);
                this.subAnnotations.add(cl);
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        JCas newView;
        try {
            newView = jcas.createView(this.viewName);
        }
        catch (CASException e) {
            e.printStackTrace();
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        JCasBuilder builder = new JCasBuilder(newView);
        for (Annotation a : JCasUtil.select((JCas)jcas, this.annotationClass)) {
            int relativ = -a.getBegin() + builder.getPosition();
            Origin o = (Origin)builder.add(a.getCoveredText(), Origin.class);
            o.setOffset(a.getBegin());
            for (Class<Annotation> subClass : this.subAnnotations) {
                for (Annotation sub : JCasUtil.selectCovered(subClass, (AnnotationFS)a)) {
                    int tgtBegin = sub.getBegin() + relativ;
                    int tgtEnd = sub.getEnd() + relativ;
                    Annotation tgt = AnnotationFactory.createAnnotation((JCas)newView, (int)(sub.getBegin() + relativ), (int)(sub.getEnd() + relativ), subClass);
                    for (Feature feature : sub.getType().getFeatures()) {
                        if (!feature.getRange().isPrimitive()) continue;
                        tgt.setFeatureValueFromString(feature, sub.getFeatureValueAsString(feature));
                    }
                    tgt.setBegin(tgtBegin);
                    tgt.setEnd(tgtEnd);
                }
            }
        }
        builder.close();
    }
}

