/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.drama.core.ml;

import de.unistuttgart.quadrama.core.api.Origin;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class MapBackFeature
extends JCasAnnotator_ImplBase {
    public static final String PARAM_ANNOTATION_TYPE = "Annotation type";
    public static final String PARAM_VIEW_NAME = "View name";
    public static final String PARAM_FEATURE_NAME = "Feature name";
    @ConfigurationParameter(name="View name")
    String viewName;
    @ConfigurationParameter(name="Annotation type")
    String annotationClassName;
    @ConfigurationParameter(name="Feature name")
    String featureName;
    Class<Annotation> annotationClass;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            Class<?> cl = Class.forName(this.annotationClassName);
            this.annotationClass = cl;
        }
        catch (ClassNotFoundException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        try {
            JCas other = jcas.getView(this.viewName);
            for (Origin origin : JCasUtil.select((JCas)other, Origin.class)) {
                int relativ = -origin.getBegin() + origin.getOffset();
                for (Annotation src : JCasUtil.selectCovered(this.annotationClass, (AnnotationFS)origin)) {
                    int tgtBegin = src.getBegin() + relativ;
                    int tgtEnd = src.getEnd() + relativ;
                    for (Annotation tgt : JCasUtil.selectCovered((JCas)jcas, this.annotationClass, (int)tgtBegin, (int)tgtEnd)) {
                        Feature feature;
                        if (tgtBegin != tgt.getBegin() || tgtEnd != tgt.getEnd() || !(feature = tgt.getType().getFeatureByBaseName(this.featureName)).getRange().getName().equalsIgnoreCase("uima.cas.String")) continue;
                        tgt.setStringValue(feature, src.getStringValue(feature));
                    }
                }
            }
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

